/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.coordinator;

import ca.uhn.fhir.batch2.api.IJobPersistence;
import ca.uhn.fhir.batch2.api.JobOperationResultJson;
import ca.uhn.fhir.batch2.coordinator.BatchWorkChunk;
import ca.uhn.fhir.batch2.model.FetchJobInstancesRequest;
import ca.uhn.fhir.batch2.model.JobInstance;
import ca.uhn.fhir.batch2.model.MarkWorkChunkAsErrorRequest;
import ca.uhn.fhir.batch2.model.StatusEnum;
import ca.uhn.fhir.batch2.model.WorkChunk;
import ca.uhn.fhir.batch2.models.JobInstanceFetchRequest;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

public class SynchronizedJobPersistenceWrapper
implements IJobPersistence {
    private final IJobPersistence myWrap;

    public SynchronizedJobPersistenceWrapper(IJobPersistence theJobPersistence) {
        this.myWrap = theJobPersistence;
    }

    @Override
    public synchronized String storeWorkChunk(BatchWorkChunk theBatchWorkChunk) {
        return this.myWrap.storeWorkChunk(theBatchWorkChunk);
    }

    @Override
    public synchronized Optional<WorkChunk> fetchWorkChunkSetStartTimeAndMarkInProgress(String theChunkId) {
        return this.myWrap.fetchWorkChunkSetStartTimeAndMarkInProgress(theChunkId);
    }

    @Override
    public synchronized String storeNewInstance(JobInstance theInstance) {
        return this.myWrap.storeNewInstance(theInstance);
    }

    @Override
    public synchronized Optional<JobInstance> fetchInstance(String theInstanceId) {
        return this.myWrap.fetchInstance(theInstanceId);
    }

    @Override
    public List<JobInstance> fetchInstances(String theJobDefinitionId, Set<StatusEnum> theStatuses, Date theCutoff, Pageable thePageable) {
        return this.myWrap.fetchInstances(theJobDefinitionId, theStatuses, theCutoff, thePageable);
    }

    @Override
    public synchronized List<JobInstance> fetchInstances(FetchJobInstancesRequest theRequest, int theStart, int theBatchSize) {
        return this.myWrap.fetchInstances(theRequest, theStart, theBatchSize);
    }

    @Override
    public synchronized List<JobInstance> fetchInstances(int thePageSize, int thePageIndex) {
        return this.myWrap.fetchInstances(thePageSize, thePageIndex);
    }

    @Override
    public List<JobInstance> fetchRecentInstances(int thePageSize, int thePageIndex) {
        return this.myWrap.fetchRecentInstances(thePageSize, thePageIndex);
    }

    @Override
    public List<JobInstance> fetchInstancesByJobDefinitionIdAndStatus(String theJobDefinitionId, Set<StatusEnum> theRequestedStatuses, int thePageSize, int thePageIndex) {
        return this.myWrap.fetchInstancesByJobDefinitionIdAndStatus(theJobDefinitionId, theRequestedStatuses, thePageSize, thePageIndex);
    }

    @Override
    public List<JobInstance> fetchInstancesByJobDefinitionId(String theJobDefinitionId, int theCount, int theStart) {
        return this.myWrap.fetchInstancesByJobDefinitionId(theJobDefinitionId, theCount, theStart);
    }

    @Override
    public Page<JobInstance> fetchJobInstances(JobInstanceFetchRequest theRequest) {
        return this.myWrap.fetchJobInstances(theRequest);
    }

    @Override
    public synchronized void markWorkChunkAsErroredAndIncrementErrorCount(String theChunkId, String theErrorMessage) {
        this.myWrap.markWorkChunkAsErroredAndIncrementErrorCount(theChunkId, theErrorMessage);
    }

    @Override
    public Optional<WorkChunk> markWorkChunkAsErroredAndIncrementErrorCount(MarkWorkChunkAsErrorRequest theParameters) {
        return this.myWrap.markWorkChunkAsErroredAndIncrementErrorCount(theParameters);
    }

    @Override
    public synchronized void markWorkChunkAsFailed(String theChunkId, String theErrorMessage) {
        this.myWrap.markWorkChunkAsFailed(theChunkId, theErrorMessage);
    }

    @Override
    public synchronized void markWorkChunkAsCompletedAndClearData(String theChunkId, int theRecordsProcessed) {
        this.myWrap.markWorkChunkAsCompletedAndClearData(theChunkId, theRecordsProcessed);
    }

    @Override
    public void markWorkChunksWithStatusAndWipeData(String theInstanceId, List<String> theChunkIds, StatusEnum theStatus, String theErrorMsg) {
        this.myWrap.markWorkChunksWithStatusAndWipeData(theInstanceId, theChunkIds, theStatus, theErrorMsg);
    }

    @Override
    public void incrementWorkChunkErrorCount(String theChunkId, int theIncrementBy) {
        this.myWrap.incrementWorkChunkErrorCount(theChunkId, theIncrementBy);
    }

    @Override
    public boolean canAdvanceInstanceToNextStep(String theInstanceId, String theCurrentStepId) {
        return this.myWrap.canAdvanceInstanceToNextStep(theInstanceId, theCurrentStepId);
    }

    @Override
    public synchronized List<WorkChunk> fetchWorkChunksWithoutData(String theInstanceId, int thePageSize, int thePageIndex) {
        return this.myWrap.fetchWorkChunksWithoutData(theInstanceId, thePageSize, thePageIndex);
    }

    @Override
    public Iterator<WorkChunk> fetchAllWorkChunksIterator(String theInstanceId, boolean theWithData) {
        return this.myWrap.fetchAllWorkChunksIterator(theInstanceId, theWithData);
    }

    @Override
    public Iterator<WorkChunk> fetchAllWorkChunksForStepIterator(String theInstanceId, String theStepId) {
        return this.myWrap.fetchAllWorkChunksForStepIterator(theInstanceId, theStepId);
    }

    @Override
    public Stream<WorkChunk> fetchAllWorkChunksForStepStream(String theInstanceId, String theStepId) {
        return this.myWrap.fetchAllWorkChunksForStepStream(theInstanceId, theStepId);
    }

    @Override
    public synchronized boolean updateInstance(JobInstance theInstance) {
        return this.myWrap.updateInstance(theInstance);
    }

    @Override
    public synchronized void deleteInstanceAndChunks(String theInstanceId) {
        this.myWrap.deleteInstanceAndChunks(theInstanceId);
    }

    @Override
    public synchronized void deleteChunks(String theInstanceId) {
        this.myWrap.deleteChunks(theInstanceId);
    }

    @Override
    public synchronized boolean markInstanceAsCompleted(String theInstanceId) {
        return this.myWrap.markInstanceAsCompleted(theInstanceId);
    }

    @Override
    public boolean markInstanceAsStatus(String theInstance, StatusEnum theStatusEnum) {
        return this.myWrap.markInstanceAsStatus(theInstance, theStatusEnum);
    }

    @Override
    public JobOperationResultJson cancelInstance(String theInstanceId) {
        return this.myWrap.cancelInstance(theInstanceId);
    }

    @Override
    public List<String> fetchallchunkidsforstepWithStatus(String theInstanceId, String theStepId, StatusEnum theStatusEnum) {
        return this.myWrap.fetchallchunkidsforstepWithStatus(theInstanceId, theStepId, theStatusEnum);
    }
}

