/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.coordinator;

import ca.uhn.fhir.batch2.api.IJobPersistence;
import ca.uhn.fhir.batch2.api.IJobStepWorker;
import ca.uhn.fhir.batch2.api.IReductionStepWorker;
import ca.uhn.fhir.batch2.api.ReductionStepExecutionDetails;
import ca.uhn.fhir.batch2.api.StepExecutionDetails;
import ca.uhn.fhir.batch2.api.VoidModel;
import ca.uhn.fhir.batch2.channel.BatchJobSender;
import ca.uhn.fhir.batch2.coordinator.BaseDataSink;
import ca.uhn.fhir.batch2.coordinator.FinalStepDataSink;
import ca.uhn.fhir.batch2.coordinator.JobDataSink;
import ca.uhn.fhir.batch2.coordinator.JobStepExecutorOutput;
import ca.uhn.fhir.batch2.coordinator.ReductionStepDataSink;
import ca.uhn.fhir.batch2.coordinator.ReductionStepExecutor;
import ca.uhn.fhir.batch2.coordinator.StepExecutor;
import ca.uhn.fhir.batch2.model.JobDefinition;
import ca.uhn.fhir.batch2.model.JobDefinitionStep;
import ca.uhn.fhir.batch2.model.JobInstance;
import ca.uhn.fhir.batch2.model.JobWorkCursor;
import ca.uhn.fhir.batch2.model.WorkChunk;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.util.Logs;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.springframework.transaction.PlatformTransactionManager;

public class WorkChunkProcessor {
    private static final Logger ourLog = Logs.getBatchTroubleshootingLog();
    public static final int MAX_CHUNK_ERROR_COUNT = 3;
    private final IJobPersistence myJobPersistence;
    private final BatchJobSender myBatchJobSender;
    private final StepExecutor myStepExecutor;
    private final ReductionStepExecutor myReductionStepExecutor;

    public WorkChunkProcessor(IJobPersistence theJobPersistence, BatchJobSender theSender, PlatformTransactionManager theTransactionManager) {
        this.myJobPersistence = theJobPersistence;
        this.myBatchJobSender = theSender;
        this.myStepExecutor = new StepExecutor(theJobPersistence);
        this.myReductionStepExecutor = new ReductionStepExecutor(theJobPersistence, theTransactionManager);
    }

    public <PT extends IModelJson, IT extends IModelJson, OT extends IModelJson> JobStepExecutorOutput<PT, IT, OT> doExecution(JobWorkCursor<PT, IT, OT> theCursor, JobInstance theInstance, @Nullable WorkChunk theWorkChunk) {
        JobDefinitionStep<PT, IT, OT> step = theCursor.getCurrentStep();
        JobDefinition<PT> jobDefinition = theCursor.getJobDefinition();
        String instanceId = theInstance.getInstanceId();
        Class<IT> inputType = step.getInputType();
        PT parameters = theInstance.getParameters(jobDefinition.getParametersType());
        IJobStepWorker<PT, IT, OT> worker = step.getJobStepWorker();
        BaseDataSink<PT, IT, OT> dataSink = this.getDataSink(theCursor, jobDefinition, instanceId);
        if (step.isReductionStep()) {
            boolean success = this.myReductionStepExecutor.executeReductionStep(theInstance, step, inputType, parameters);
            if (success) {
                ReductionStepExecutionDetails reductionStepExecutionDetails = new ReductionStepExecutionDetails(parameters, theInstance);
                IReductionStepWorker reductionStepWorker = (IReductionStepWorker)step.getJobStepWorker();
                success = this.myStepExecutor.executeStep(reductionStepExecutionDetails, reductionStepWorker, dataSink);
            }
            return new JobStepExecutorOutput<PT, IT, OT>(success, dataSink);
        }
        Validate.notNull((Object)theWorkChunk);
        Optional<StepExecutionDetails<PT, IT>> stepExecutionDetailsOpt = this.getExecutionDetailsForNonReductionStep(theWorkChunk, theInstance, inputType, parameters);
        if (!stepExecutionDetailsOpt.isPresent()) {
            return new JobStepExecutorOutput<PT, IT, OT>(false, dataSink);
        }
        StepExecutionDetails<PT, IT> stepExecutionDetails = stepExecutionDetailsOpt.get();
        boolean success = this.myStepExecutor.executeStep(stepExecutionDetails, worker, dataSink);
        return new JobStepExecutorOutput<PT, IT, OT>(success, dataSink);
    }

    protected <PT extends IModelJson, IT extends IModelJson, OT extends IModelJson> BaseDataSink<PT, IT, OT> getDataSink(JobWorkCursor<PT, IT, OT> theCursor, JobDefinition<PT> theJobDefinition, String theInstanceId) {
        BaseDataSink dataSink = theCursor.isReductionStep() ? new ReductionStepDataSink<PT, IT, OT>(theInstanceId, theCursor, theJobDefinition, this.myJobPersistence) : (theCursor.isFinalStep() ? new FinalStepDataSink<PT, IT>(theJobDefinition.getJobDefinitionId(), theInstanceId, theCursor.asFinalCursor()) : new JobDataSink<PT, IT, OT>(this.myBatchJobSender, this.myJobPersistence, theJobDefinition, theInstanceId, theCursor));
        return dataSink;
    }

    private <PT extends IModelJson, IT extends IModelJson> Optional<StepExecutionDetails<PT, IT>> getExecutionDetailsForNonReductionStep(WorkChunk theWorkChunk, JobInstance theInstance, Class<IT> theInputType, PT theParameters) {
        Object inputData = null;
        if (!theInputType.equals(VoidModel.class)) {
            if (StringUtils.isBlank((CharSequence)theWorkChunk.getData())) {
                ourLog.info("Ignoring chunk[{}] for step[{}] in status[{}] because it has no data", new Object[]{theWorkChunk.getId(), theWorkChunk.getTargetStepId(), theWorkChunk.getStatus()});
                return Optional.empty();
            }
            inputData = theWorkChunk.getData(theInputType);
        }
        String chunkId = theWorkChunk.getId();
        return Optional.of(new StepExecutionDetails<PT, Object>(theParameters, inputData, theInstance, chunkId));
    }
}

