/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.step;

import ca.uhn.fhir.batch2.api.IFirstJobStepWorker;
import ca.uhn.fhir.batch2.api.IJobDataSink;
import ca.uhn.fhir.batch2.api.JobExecutionFailedException;
import ca.uhn.fhir.batch2.api.RunOutcome;
import ca.uhn.fhir.batch2.api.StepExecutionDetails;
import ca.uhn.fhir.batch2.api.VoidModel;
import ca.uhn.fhir.batch2.jobs.chunk.PartitionedUrlChunkRangeJson;
import ca.uhn.fhir.batch2.jobs.parameters.PartitionedUrl;
import ca.uhn.fhir.batch2.jobs.parameters.PartitionedUrlListJobParameters;
import ca.uhn.fhir.batch2.util.Batch2Constants;
import ca.uhn.fhir.util.Logs;
import java.util.Date;
import javax.annotation.Nonnull;
import org.slf4j.Logger;

public class GenerateRangeChunksStep<PT extends PartitionedUrlListJobParameters>
implements IFirstJobStepWorker<PT, PartitionedUrlChunkRangeJson> {
    private static final Logger ourLog = Logs.getBatchTroubleshootingLog();

    @Override
    @Nonnull
    public RunOutcome run(@Nonnull StepExecutionDetails<PT, VoidModel> theStepExecutionDetails, @Nonnull IJobDataSink<PartitionedUrlChunkRangeJson> theDataSink) throws JobExecutionFailedException {
        PartitionedUrlListJobParameters params = (PartitionedUrlListJobParameters)theStepExecutionDetails.getParameters();
        Date start = Batch2Constants.BATCH_START_DATE;
        Date end = new Date();
        if (params.getPartitionedUrls().isEmpty()) {
            ourLog.info("Searching for All Resources from {} to {}", (Object)start, (Object)end);
            PartitionedUrlChunkRangeJson nextRange = new PartitionedUrlChunkRangeJson();
            nextRange.setStart(start);
            nextRange.setEnd(end);
            theDataSink.accept(nextRange);
        } else {
            for (PartitionedUrl nextPartitionedUrl : params.getPartitionedUrls()) {
                ourLog.info("Searching for [{}]] from {} to {}", new Object[]{nextPartitionedUrl, start, end});
                PartitionedUrlChunkRangeJson nextRange = new PartitionedUrlChunkRangeJson();
                nextRange.setPartitionedUrl(nextPartitionedUrl);
                nextRange.setStart(start);
                nextRange.setEnd(end);
                theDataSink.accept(nextRange);
            }
        }
        return RunOutcome.SUCCESS;
    }
}

