/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.step;

import ca.uhn.fhir.batch2.jobs.chunk.PartitionedUrlChunkRangeJson;
import ca.uhn.fhir.batch2.jobs.parameters.PartitionedUrl;
import ca.uhn.fhir.batch2.jobs.step.IIdChunkProducer;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.pid.IResourcePidList;
import ca.uhn.fhir.jpa.api.svc.IBatch2DaoSvc;
import ca.uhn.fhir.util.Logs;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public class PartitionedUrlListIdChunkProducer
implements IIdChunkProducer<PartitionedUrlChunkRangeJson> {
    private static final Logger ourLog = Logs.getBatchTroubleshootingLog();
    private final IBatch2DaoSvc myBatch2DaoSvc;

    public PartitionedUrlListIdChunkProducer(IBatch2DaoSvc theBatch2DaoSvc) {
        this.myBatch2DaoSvc = theBatch2DaoSvc;
    }

    @Override
    public IResourcePidList fetchResourceIdsPage(Date theNextStart, Date theEnd, @Nonnull Integer thePageSize, @Nullable RequestPartitionId theRequestPartitionId, PartitionedUrlChunkRangeJson theData) {
        PartitionedUrl partitionedUrl = theData.getPartitionedUrl();
        if (partitionedUrl == null) {
            ourLog.info("Fetching resource ID chunk for everything - Range {} - {}", (Object)theNextStart, (Object)theEnd);
            return this.myBatch2DaoSvc.fetchResourceIdsPage(theNextStart, theEnd, thePageSize, theRequestPartitionId, null);
        }
        ourLog.info("Fetching resource ID chunk for URL {} - Range {} - {}", new Object[]{partitionedUrl.getUrl(), theNextStart, theEnd});
        return this.myBatch2DaoSvc.fetchResourceIdsPage(theNextStart, theEnd, thePageSize, partitionedUrl.getRequestPartitionId(), partitionedUrl.getUrl());
    }
}

