/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.step;

import ca.uhn.fhir.batch2.api.IJobDataSink;
import ca.uhn.fhir.batch2.api.IJobStepWorker;
import ca.uhn.fhir.batch2.api.JobExecutionFailedException;
import ca.uhn.fhir.batch2.api.RunOutcome;
import ca.uhn.fhir.batch2.api.StepExecutionDetails;
import ca.uhn.fhir.batch2.jobs.chunk.ChunkRangeJson;
import ca.uhn.fhir.batch2.jobs.chunk.ResourceIdListWorkChunkJson;
import ca.uhn.fhir.batch2.jobs.chunk.TypedPidJson;
import ca.uhn.fhir.batch2.jobs.parameters.PartitionedJobParameters;
import ca.uhn.fhir.batch2.jobs.step.IIdChunkProducer;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.pid.IResourcePidList;
import ca.uhn.fhir.jpa.api.pid.TypedResourcePid;
import ca.uhn.fhir.util.Logs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.annotation.Nonnull;
import org.slf4j.Logger;

public class ResourceIdListStep<PT extends PartitionedJobParameters, IT extends ChunkRangeJson>
implements IJobStepWorker<PT, IT, ResourceIdListWorkChunkJson> {
    private static final Logger ourLog = Logs.getBatchTroubleshootingLog();
    public static final int DEFAULT_PAGE_SIZE = 20000;
    private static final int MAX_BATCH_OF_IDS = 500;
    private final IIdChunkProducer<IT> myIdChunkProducer;

    public ResourceIdListStep(IIdChunkProducer<IT> theIdChunkProducer) {
        this.myIdChunkProducer = theIdChunkProducer;
    }

    @Override
    @Nonnull
    public RunOutcome run(@Nonnull StepExecutionDetails<PT, IT> theStepExecutionDetails, @Nonnull IJobDataSink<ResourceIdListWorkChunkJson> theDataSink) throws JobExecutionFailedException {
        ChunkRangeJson data = (ChunkRangeJson)theStepExecutionDetails.getData();
        Date start = data.getStart();
        Date end = data.getEnd();
        Integer pageSize = ((PartitionedJobParameters)theStepExecutionDetails.getParameters()).getBatchSize();
        if (pageSize == null) {
            pageSize = 20000;
        }
        ourLog.info("Beginning scan for reindex IDs in range {} to {}", (Object)start, (Object)end);
        Date nextStart = start;
        RequestPartitionId requestPartitionId = ((PartitionedJobParameters)theStepExecutionDetails.getParameters()).getRequestPartitionId();
        LinkedHashSet<TypedPidJson> idBuffer = new LinkedHashSet<TypedPidJson>();
        long previousLastTime = 0L;
        int totalIdsFound = 0;
        int chunkCount = 0;
        block0: while (true) {
            IResourcePidList nextChunk;
            if ((nextChunk = this.myIdChunkProducer.fetchResourceIdsPage(nextStart, end, pageSize, requestPartitionId, (ChunkRangeJson)theStepExecutionDetails.getData())).isEmpty()) {
                ourLog.info("No data returned");
                break;
            }
            ourLog.info("Found {} IDs from {} to {}", new Object[]{nextChunk.size(), nextStart, nextChunk.getLastDate()});
            for (TypedResourcePid typedResourcePid : nextChunk.getTypedResourcePids()) {
                TypedPidJson nextId = new TypedPidJson(typedResourcePid);
                idBuffer.add(nextId);
            }
            if (nextChunk.getLastDate().getTime() == previousLastTime) {
                ourLog.info("Matching final timestamp of {}, loading is completed", (Object)new Date(previousLastTime));
                break;
            }
            previousLastTime = nextChunk.getLastDate().getTime();
            nextStart = nextChunk.getLastDate();
            while (true) {
                if (idBuffer.size() <= 500) continue block0;
                ArrayList<TypedPidJson> submissionIds = new ArrayList<TypedPidJson>();
                Iterator iter = idBuffer.iterator();
                while (iter.hasNext()) {
                    submissionIds.add((TypedPidJson)iter.next());
                    iter.remove();
                    if (submissionIds.size() != 500) continue;
                }
                totalIdsFound += submissionIds.size();
                ++chunkCount;
                this.submitWorkChunk(submissionIds, theDataSink);
            }
            break;
        }
        this.submitWorkChunk(idBuffer, theDataSink);
        ourLog.info("Submitted {} chunks with {} resource IDs", (Object)(++chunkCount), (Object)(totalIdsFound += idBuffer.size()));
        return RunOutcome.SUCCESS;
    }

    private void submitWorkChunk(Collection<TypedPidJson> theTypedPids, IJobDataSink<ResourceIdListWorkChunkJson> theDataSink) {
        if (theTypedPids.isEmpty()) {
            return;
        }
        ourLog.info("Submitting work chunk with {} IDs", (Object)theTypedPids.size());
        ResourceIdListWorkChunkJson data = new ResourceIdListWorkChunkJson(theTypedPids);
        ourLog.debug("IDs are: {}", (Object)data);
        theDataSink.accept(data);
    }
}

