/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.maintenance;

import ca.uhn.fhir.batch2.model.StatusEnum;
import ca.uhn.fhir.batch2.model.WorkChunk;
import ca.uhn.fhir.util.Logs;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;

public class JobChunkProgressAccumulator {
    private static final Logger ourLog = Logs.getBatchTroubleshootingLog();
    private final Set<String> myConsumedInstanceAndChunkIds = new HashSet<String>();
    private final Multimap<String, ChunkStatusCountValue> myInstanceIdToChunkStatuses = ArrayListMultimap.create();

    int countChunksWithStatus(String theInstanceId, String theStepId, StatusEnum ... theStatuses) {
        return this.getChunkIdsWithStatus(theInstanceId, theStepId, theStatuses).size();
    }

    int getTotalChunkCountForInstanceAndStep(String theInstanceId, String theStepId) {
        return this.myInstanceIdToChunkStatuses.get((Object)theInstanceId).stream().filter(chunkCount -> chunkCount.myStepId.equals(theStepId)).collect(Collectors.toList()).size();
    }

    public List<String> getChunkIdsWithStatus(String theInstanceId, String theStepId, StatusEnum ... theStatuses) {
        return this.getChunkStatuses(theInstanceId).stream().filter(t -> t.myStepId.equals(theStepId)).filter(t -> ArrayUtils.contains((Object[])theStatuses, (Object)((Object)t.myStatus))).map(t -> t.myChunkId).collect(Collectors.toList());
    }

    @Nonnull
    private Collection<ChunkStatusCountValue> getChunkStatuses(String theInstanceId) {
        Collection chunkStatuses = this.myInstanceIdToChunkStatuses.get((Object)theInstanceId);
        chunkStatuses = (Collection)ObjectUtils.defaultIfNull((Object)chunkStatuses, Collections.emptyList());
        return chunkStatuses;
    }

    public void addChunk(WorkChunk theChunk) {
        String chunkId;
        String instanceId = theChunk.getInstanceId();
        if (this.myConsumedInstanceAndChunkIds.add(instanceId + " " + (chunkId = theChunk.getId()))) {
            ourLog.debug("Adding chunk to accumulator. [chunkId={}, instanceId={}, status={}]", new Object[]{chunkId, instanceId, theChunk.getStatus()});
            this.myInstanceIdToChunkStatuses.put((Object)instanceId, (Object)new ChunkStatusCountValue(chunkId, theChunk.getTargetStepId(), theChunk.getStatus()));
        }
    }

    private static class ChunkStatusCountValue {
        public final String myChunkId;
        public final String myStepId;
        public final StatusEnum myStatus;

        private ChunkStatusCountValue(String theChunkId, String theStepId, StatusEnum theStatus) {
            this.myChunkId = theChunkId;
            this.myStepId = theStepId;
            this.myStatus = theStatus;
        }
    }
}

