/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.model;

import ca.uhn.fhir.batch2.model.JobDefinition;
import ca.uhn.fhir.batch2.model.JobInstance;
import ca.uhn.fhir.model.api.IModelJson;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nonnull;

public class JobWorkNotification
implements IModelJson {
    @JsonProperty(value="jobDefinitionId")
    private String myJobDefinitionId;
    @JsonProperty(value="jobDefinitionVersion")
    private int myJobDefinitionVersion;
    @JsonProperty(value="targetStepId")
    private String myTargetStepId;
    @JsonProperty(value="chunkId")
    private String myChunkId;
    @JsonProperty(value="instanceId")
    private String myInstanceId;

    public JobWorkNotification() {
    }

    public JobWorkNotification(@Nonnull String theJobDefinitionId, int jobDefinitionVersion, @Nonnull String theInstanceId, @Nonnull String theTargetStepId, @Nonnull String theChunkId) {
        this.setJobDefinitionId(theJobDefinitionId);
        this.setJobDefinitionVersion(jobDefinitionVersion);
        this.setChunkId(theChunkId);
        this.setInstanceId(theInstanceId);
        this.setTargetStepId(theTargetStepId);
    }

    public JobWorkNotification(JobInstance theInstance, String theNextStepId, String theNextChunkId) {
        this(theInstance.getJobDefinitionId(), theInstance.getJobDefinitionVersion(), theInstance.getInstanceId(), theNextStepId, theNextChunkId);
    }

    public static JobWorkNotification firstStepNotification(JobDefinition<?> theJobDefinition, String theInstanceId, String theChunkId) {
        String firstStepId = theJobDefinition.getFirstStepId();
        String jobDefinitionId = theJobDefinition.getJobDefinitionId();
        int jobDefinitionVersion = theJobDefinition.getJobDefinitionVersion();
        return new JobWorkNotification(jobDefinitionId, jobDefinitionVersion, theInstanceId, firstStepId, theChunkId);
    }

    public String getJobDefinitionId() {
        return this.myJobDefinitionId;
    }

    public void setJobDefinitionId(String theJobDefinitionId) {
        this.myJobDefinitionId = theJobDefinitionId;
    }

    public int getJobDefinitionVersion() {
        return this.myJobDefinitionVersion;
    }

    public void setJobDefinitionVersion(int theJobDefinitionVersion) {
        this.myJobDefinitionVersion = theJobDefinitionVersion;
    }

    public String getTargetStepId() {
        return this.myTargetStepId;
    }

    public void setTargetStepId(String theTargetStepId) {
        this.myTargetStepId = theTargetStepId;
    }

    public String getChunkId() {
        return this.myChunkId;
    }

    public void setChunkId(String theChunkId) {
        this.myChunkId = theChunkId;
    }

    public void setInstanceId(String theInstanceId) {
        this.myInstanceId = theInstanceId;
    }

    public String getInstanceId() {
        return this.myInstanceId;
    }

    public String toString() {
        return String.format("job[%s] instance[%s] step[%s] chunk[%s]", this.myJobDefinitionId, this.myInstanceId, this.myTargetStepId, this.myChunkId);
    }
}

