/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.model;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.util.Logs;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;

public enum StatusEnum {
    QUEUED(true, false, true),
    IN_PROGRESS(true, false, true),
    FINALIZE(true, false, true),
    COMPLETED(false, true, false),
    ERRORED(true, true, false),
    FAILED(true, true, false),
    CANCELLED(true, true, false);

    private static final Logger ourLog;
    private final boolean myIncomplete;
    private final boolean myEnded;
    private final boolean myIsCancellable;
    private static StatusEnum[] ourIncompleteStatuses;
    private static Set<StatusEnum> ourEndedStatuses;
    private static Set<StatusEnum> ourNotEndedStatuses;

    private StatusEnum(boolean theIncomplete, boolean theEnded, boolean theIsCancellable) {
        this.myIncomplete = theIncomplete;
        this.myEnded = theEnded;
        this.myIsCancellable = theIsCancellable;
    }

    public static StatusEnum[] getIncompleteStatuses() {
        StatusEnum[] retVal = ourIncompleteStatuses;
        if (retVal == null) {
            EnumSet<StatusEnum> incompleteSet = EnumSet.noneOf(StatusEnum.class);
            for (StatusEnum next : StatusEnum.values()) {
                if (!next.myIncomplete) continue;
                incompleteSet.add(next);
            }
            ourIncompleteStatuses = incompleteSet.toArray(new StatusEnum[0]);
            retVal = ourIncompleteStatuses;
        }
        return retVal;
    }

    @Nonnull
    public static Set<StatusEnum> getEndedStatuses() {
        Set<StatusEnum> retVal = ourEndedStatuses;
        if (retVal == null) {
            StatusEnum.initializeStaticEndedStatuses();
        }
        retVal = ourEndedStatuses;
        return retVal;
    }

    @Nonnull
    public static Set<StatusEnum> getNotEndedStatuses() {
        Set<StatusEnum> retVal = ourNotEndedStatuses;
        if (retVal == null) {
            StatusEnum.initializeStaticEndedStatuses();
        }
        retVal = ourNotEndedStatuses;
        return retVal;
    }

    @Nonnull
    private static void initializeStaticEndedStatuses() {
        EnumSet<StatusEnum> endedSet = EnumSet.noneOf(StatusEnum.class);
        EnumSet<StatusEnum> notEndedSet = EnumSet.noneOf(StatusEnum.class);
        for (StatusEnum next : StatusEnum.values()) {
            if (next.myEnded) {
                endedSet.add(next);
                continue;
            }
            notEndedSet.add(next);
        }
        ourEndedStatuses = Collections.unmodifiableSet(endedSet);
        ourNotEndedStatuses = Collections.unmodifiableSet(notEndedSet);
    }

    public static boolean isLegalStateTransition(StatusEnum theOrigStatus, StatusEnum theNewStatus) {
        Boolean canTransition;
        if (theOrigStatus == theNewStatus) {
            return true;
        }
        switch (theOrigStatus) {
            case QUEUED: {
                canTransition = true;
                break;
            }
            case IN_PROGRESS: {
                canTransition = theNewStatus != QUEUED;
                break;
            }
            case ERRORED: {
                canTransition = theNewStatus == FAILED || theNewStatus == COMPLETED || theNewStatus == CANCELLED;
                break;
            }
            case COMPLETED: 
            case CANCELLED: 
            case FAILED: {
                canTransition = false;
                break;
            }
            case FINALIZE: {
                canTransition = theNewStatus != QUEUED && theNewStatus != IN_PROGRESS;
                break;
            }
            default: {
                canTransition = null;
            }
        }
        if (canTransition == null) {
            throw new IllegalStateException(Msg.code((int)2131) + "Unknown batch state " + theOrigStatus);
        }
        if (!canTransition.booleanValue()) {
            ourLog.trace("Tried to execute an illegal state transition. [origStatus={}, newStatus={}]", (Object)theOrigStatus, (Object)theNewStatus);
        }
        return canTransition;
    }

    public boolean isIncomplete() {
        return this.myIncomplete;
    }

    public boolean isCancellable() {
        return this.myIsCancellable;
    }

    static {
        ourLog = Logs.getBatchTroubleshootingLog();
    }
}

