/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.progress;

import ca.uhn.fhir.batch2.model.JobInstance;
import ca.uhn.fhir.batch2.model.StatusEnum;
import ca.uhn.fhir.batch2.model.WorkChunk;
import ca.uhn.fhir.util.Logs;
import ca.uhn.fhir.util.StopWatch;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;

class InstanceProgress {
    private static final Logger ourLog = Logs.getBatchTroubleshootingLog();
    private int myRecordsProcessed = 0;
    private int myIncompleteChunkCount = 0;
    private int myQueuedCount = 0;
    private int myCompleteChunkCount = 0;
    private int myErroredChunkCount = 0;
    private int myFailedChunkCount = 0;
    private int myErrorCountForAllStatuses = 0;
    private Long myEarliestStartTime = null;
    private Long myLatestEndTime = null;
    private String myErrormessage = null;
    private StatusEnum myNewStatus = null;
    private Map<String, Map<StatusEnum, Integer>> myStepToStatusCountMap = new HashMap<String, Map<StatusEnum, Integer>>();

    InstanceProgress() {
    }

    public void addChunk(WorkChunk theChunk) {
        this.myErrorCountForAllStatuses += theChunk.getErrorCount();
        this.updateRecordsProcessed(theChunk);
        this.updateEarliestTime(theChunk);
        this.updateLatestEndTime(theChunk);
        this.updateCompletionStatus(theChunk);
    }

    private void updateCompletionStatus(WorkChunk theChunk) {
        Map statusToCountMap = this.myStepToStatusCountMap.getOrDefault(theChunk.getTargetStepId(), new HashMap());
        statusToCountMap.put(theChunk.getStatus(), statusToCountMap.getOrDefault((Object)theChunk.getStatus(), 0) + 1);
        switch (theChunk.getStatus()) {
            case QUEUED: 
            case IN_PROGRESS: {
                ++this.myIncompleteChunkCount;
                break;
            }
            case COMPLETED: {
                ++this.myCompleteChunkCount;
                break;
            }
            case ERRORED: {
                ++this.myErroredChunkCount;
                if (this.myErrormessage != null) break;
                this.myErrormessage = theChunk.getErrorMessage();
                break;
            }
            case FAILED: {
                ++this.myFailedChunkCount;
                this.myErrormessage = theChunk.getErrorMessage();
                break;
            }
        }
        ourLog.trace("Chunk has status {} with errored chunk count {}", (Object)theChunk.getStatus(), (Object)this.myErroredChunkCount);
    }

    private void updateLatestEndTime(WorkChunk theChunk) {
        if (theChunk.getEndTime() != null && (this.myLatestEndTime == null || this.myLatestEndTime < theChunk.getEndTime().getTime())) {
            this.myLatestEndTime = theChunk.getEndTime().getTime();
        }
    }

    private void updateEarliestTime(WorkChunk theChunk) {
        if (theChunk.getStartTime() != null && (this.myEarliestStartTime == null || this.myEarliestStartTime > theChunk.getStartTime().getTime())) {
            this.myEarliestStartTime = theChunk.getStartTime().getTime();
        }
    }

    private void updateRecordsProcessed(WorkChunk theChunk) {
        if (theChunk.getRecordsProcessed() != null) {
            this.myRecordsProcessed += theChunk.getRecordsProcessed().intValue();
        }
    }

    public void updateInstance(JobInstance theInstance) {
        if (this.myEarliestStartTime != null) {
            theInstance.setStartTime(new Date(this.myEarliestStartTime));
        }
        theInstance.setErrorCount(this.myErrorCountForAllStatuses);
        theInstance.setCombinedRecordsProcessed(this.myRecordsProcessed);
        this.updateStatus(theInstance);
        this.setEndTime(theInstance);
        theInstance.setErrorMessage(this.myErrormessage);
    }

    private void setEndTime(JobInstance theInstance) {
        if (this.myLatestEndTime != null) {
            if (this.myFailedChunkCount > 0) {
                theInstance.setEndTime(new Date(this.myLatestEndTime));
            } else if (this.myCompleteChunkCount > 0 && this.myIncompleteChunkCount == 0 && this.myErroredChunkCount == 0) {
                theInstance.setEndTime(new Date(this.myLatestEndTime));
            }
        }
    }

    private void updateStatus(JobInstance theInstance) {
        ourLog.trace("Updating status for instance with errors: {}", (Object)this.myErroredChunkCount);
        if (this.myCompleteChunkCount >= 1 || this.myErroredChunkCount >= 1) {
            long elapsedTime;
            double percentComplete = (double)this.myCompleteChunkCount / (double)(this.myIncompleteChunkCount + this.myCompleteChunkCount + this.myFailedChunkCount + this.myErroredChunkCount);
            theInstance.setProgress(percentComplete);
            if (this.jobSuccessfullyCompleted()) {
                this.myNewStatus = StatusEnum.COMPLETED;
            } else if (this.myErroredChunkCount > 0) {
                this.myNewStatus = StatusEnum.ERRORED;
            }
            ourLog.trace("Status is now {} with errored chunk count {}", (Object)this.myNewStatus, (Object)this.myErroredChunkCount);
            if (this.myEarliestStartTime != null && this.myLatestEndTime != null && (elapsedTime = this.myLatestEndTime - this.myEarliestStartTime) > 0L) {
                double throughput = StopWatch.getThroughput((long)this.myRecordsProcessed, (long)elapsedTime, (TimeUnit)TimeUnit.SECONDS);
                theInstance.setCombinedRecordsProcessedPerSecond(throughput);
                String estimatedTimeRemaining = StopWatch.formatEstimatedTimeRemaining((double)this.myCompleteChunkCount, (double)(this.myCompleteChunkCount + this.myIncompleteChunkCount), (double)elapsedTime);
                theInstance.setEstimatedTimeRemaining(estimatedTimeRemaining);
            }
        }
    }

    private boolean jobSuccessfullyCompleted() {
        return this.myIncompleteChunkCount == 0 && this.myErroredChunkCount == 0 && this.myFailedChunkCount == 0;
    }

    public boolean failed() {
        return this.myFailedChunkCount > 0;
    }

    public boolean changed() {
        return this.myIncompleteChunkCount + this.myCompleteChunkCount + this.myErroredChunkCount >= 2 || this.myErrorCountForAllStatuses > 0;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this).append("myIncompleteChunkCount", this.myIncompleteChunkCount).append("myCompleteChunkCount", this.myCompleteChunkCount).append("myErroredChunkCount", this.myErroredChunkCount).append("myFailedChunkCount", this.myFailedChunkCount).append("myErrormessage", (Object)this.myErrormessage).append("myRecordsProcessed", this.myRecordsProcessed);
        builder.append("myStepToStatusCountMap", this.myStepToStatusCountMap);
        return builder.toString();
    }

    public StatusEnum getNewStatus() {
        return this.myNewStatus;
    }

    public boolean hasNewStatus() {
        return this.myNewStatus != null;
    }
}

