/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.progress;

import ca.uhn.fhir.batch2.api.IJobPersistence;
import ca.uhn.fhir.batch2.maintenance.JobChunkProgressAccumulator;
import ca.uhn.fhir.batch2.model.JobInstance;
import ca.uhn.fhir.batch2.model.StatusEnum;
import ca.uhn.fhir.batch2.model.WorkChunk;
import ca.uhn.fhir.batch2.progress.InstanceProgress;
import ca.uhn.fhir.batch2.progress.JobInstanceStatusUpdater;
import ca.uhn.fhir.util.Logs;
import java.util.Iterator;
import org.slf4j.Logger;

public class JobInstanceProgressCalculator {
    private static final Logger ourLog = Logs.getBatchTroubleshootingLog();
    private final IJobPersistence myJobPersistence;
    private final JobInstance myInstance;
    private final JobChunkProgressAccumulator myProgressAccumulator;
    private final JobInstanceStatusUpdater myJobInstanceStatusUpdater;

    public JobInstanceProgressCalculator(IJobPersistence theJobPersistence, JobInstance theInstance, JobChunkProgressAccumulator theProgressAccumulator) {
        this.myJobPersistence = theJobPersistence;
        this.myInstance = theInstance;
        this.myProgressAccumulator = theProgressAccumulator;
        this.myJobInstanceStatusUpdater = new JobInstanceStatusUpdater(theJobPersistence);
    }

    public void calculateAndStoreInstanceProgress() {
        InstanceProgress instanceProgress = new InstanceProgress();
        Iterator<WorkChunk> workChunkIterator = this.myJobPersistence.fetchAllWorkChunksIterator(this.myInstance.getInstanceId(), false);
        while (workChunkIterator.hasNext()) {
            WorkChunk next = workChunkIterator.next();
            this.myProgressAccumulator.addChunk(next);
            instanceProgress.addChunk(next);
        }
        instanceProgress.updateInstance(this.myInstance);
        if (instanceProgress.failed()) {
            this.myJobInstanceStatusUpdater.setFailed(this.myInstance);
            return;
        }
        if (instanceProgress.changed() || this.myInstance.getStatus() == StatusEnum.IN_PROGRESS) {
            if (this.myInstance.getCombinedRecordsProcessed() > 0) {
                ourLog.info("Job {} of type {} has status {} - {} records processed ({}/sec) - ETA: {}", new Object[]{this.myInstance.getInstanceId(), this.myInstance.getJobDefinitionId(), this.myInstance.getStatus(), this.myInstance.getCombinedRecordsProcessed(), this.myInstance.getCombinedRecordsProcessedPerSecond(), this.myInstance.getEstimatedTimeRemaining()});
                ourLog.debug(instanceProgress.toString());
            } else {
                ourLog.info("Job {} of type {} has status {} - {} records processed", new Object[]{this.myInstance.getInstanceId(), this.myInstance.getJobDefinitionId(), this.myInstance.getStatus(), this.myInstance.getCombinedRecordsProcessed()});
                ourLog.debug(instanceProgress.toString());
            }
        }
        if (instanceProgress.changed()) {
            if (instanceProgress.hasNewStatus()) {
                this.myJobInstanceStatusUpdater.updateInstanceStatus(this.myInstance, instanceProgress.getNewStatus());
            } else {
                this.myJobPersistence.updateInstance(this.myInstance);
            }
        }
    }
}

