/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.progress;

import ca.uhn.fhir.batch2.api.IJobCompletionHandler;
import ca.uhn.fhir.batch2.api.IJobPersistence;
import ca.uhn.fhir.batch2.api.JobCompletionDetails;
import ca.uhn.fhir.batch2.model.JobDefinition;
import ca.uhn.fhir.batch2.model.JobInstance;
import ca.uhn.fhir.batch2.model.StatusEnum;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.util.Logs;
import java.util.Optional;
import org.slf4j.Logger;

public class JobInstanceStatusUpdater {
    private static final Logger ourLog = Logs.getBatchTroubleshootingLog();
    private final IJobPersistence myJobPersistence;

    public JobInstanceStatusUpdater(IJobPersistence theJobPersistence) {
        this.myJobPersistence = theJobPersistence;
    }

    public boolean updateInstanceStatus(JobInstance theJobInstance, StatusEnum theNewStatus) {
        StatusEnum origStatus = theJobInstance.getStatus();
        if (origStatus == theNewStatus) {
            return false;
        }
        if (!StatusEnum.isLegalStateTransition(origStatus, theNewStatus)) {
            ourLog.error("Ignoring illegal state transition for job instance {} of type {} from {} to {}", new Object[]{theJobInstance.getInstanceId(), theJobInstance.getJobDefinitionId(), origStatus, theNewStatus});
            return false;
        }
        theJobInstance.setStatus(theNewStatus);
        ourLog.debug("Updating job instance {} of type {} from {} to {}", new Object[]{theJobInstance.getInstanceId(), theJobInstance.getJobDefinitionId(), origStatus, theNewStatus});
        return this.updateInstance(theJobInstance);
    }

    private boolean updateInstance(JobInstance theJobInstance) {
        StatusEnum newStatus;
        Optional<JobInstance> oInstance = this.myJobPersistence.fetchInstance(theJobInstance.getInstanceId());
        if (oInstance.isEmpty()) {
            ourLog.error("Trying to update instance of non-existent Instance {}", (Object)theJobInstance);
            return false;
        }
        StatusEnum origStatus = oInstance.get().getStatus();
        if (!StatusEnum.isLegalStateTransition(origStatus, newStatus = theJobInstance.getStatus())) {
            ourLog.error("Ignoring illegal state transition for job instance {} of type {} from {} to {}", new Object[]{theJobInstance.getInstanceId(), theJobInstance.getJobDefinitionId(), origStatus, newStatus});
            return false;
        }
        boolean statusChanged = this.myJobPersistence.updateInstance(theJobInstance);
        if (statusChanged) {
            ourLog.info("Changing job instance {} of type {} from {} to {}", new Object[]{theJobInstance.getInstanceId(), theJobInstance.getJobDefinitionId(), origStatus, theJobInstance.getStatus()});
            this.handleStatusChange(origStatus, theJobInstance);
        }
        return statusChanged;
    }

    private <PT extends IModelJson> void handleStatusChange(StatusEnum theOrigStatus, JobInstance theJobInstance) {
        JobDefinition<?> definition = theJobInstance.getJobDefinition();
        switch (theJobInstance.getStatus()) {
            case COMPLETED: {
                this.invokeCompletionHandler(theJobInstance, definition, definition.getCompletionHandler());
                break;
            }
            case FAILED: 
            case CANCELLED: {
                this.invokeCompletionHandler(theJobInstance, definition, definition.getErrorHandler());
                break;
            }
        }
    }

    private <PT extends IModelJson> void invokeCompletionHandler(JobInstance theJobInstance, JobDefinition<PT> theJobDefinition, IJobCompletionHandler<PT> theJobCompletionHandler) {
        if (theJobCompletionHandler == null) {
            return;
        }
        PT jobParameters = theJobInstance.getParameters(theJobDefinition.getParametersType());
        JobCompletionDetails<PT> completionDetails = new JobCompletionDetails<PT>(jobParameters, theJobInstance);
        theJobCompletionHandler.jobComplete(completionDetails);
    }

    public boolean setCompleted(JobInstance theInstance) {
        return this.updateInstanceStatus(theInstance, StatusEnum.COMPLETED);
    }

    public boolean setInProgress(JobInstance theInstance) {
        return this.updateInstanceStatus(theInstance, StatusEnum.IN_PROGRESS);
    }

    public boolean setCancelled(JobInstance theInstance) {
        return this.updateInstanceStatus(theInstance, StatusEnum.CANCELLED);
    }

    public boolean setFailed(JobInstance theInstance) {
        return this.updateInstanceStatus(theInstance, StatusEnum.FAILED);
    }
}

