/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.api;

import ca.uhn.fhir.batch2.api.IJobInstance;
import ca.uhn.fhir.batch2.model.JobInstance;
import ca.uhn.fhir.model.api.IModelJson;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;

public class StepExecutionDetails<PT extends IModelJson, IT extends IModelJson> {
    private final PT myParameters;
    private final IT myData;
    private final IJobInstance myInstance;
    private final String myChunkId;

    public StepExecutionDetails(@Nonnull PT theParameters, @Nullable IT theData, @Nonnull JobInstance theInstance, @Nonnull String theChunkId) {
        Validate.notNull(theParameters);
        this.myParameters = theParameters;
        this.myData = theData;
        this.myInstance = new JobInstance(theInstance);
        this.myChunkId = theChunkId;
    }

    @Nonnull
    public IT getData() {
        Validate.notNull(this.myData);
        return this.myData;
    }

    @Nonnull
    public PT getParameters() {
        return this.myParameters;
    }

    @Nonnull
    public IJobInstance getInstance() {
        return this.myInstance;
    }

    @Nonnull
    public String getChunkId() {
        return this.myChunkId;
    }

    public boolean hasAssociatedWorkChunk() {
        return true;
    }
}

