/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.coordinator;

import ca.uhn.fhir.batch2.api.IJobParametersValidator;
import ca.uhn.fhir.batch2.model.JobDefinition;
import ca.uhn.fhir.batch2.model.JobInstanceStartRequest;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.apache.commons.lang3.ObjectUtils;

class JobParameterJsonValidator {
    private final ValidatorFactory myValidatorFactory = Validation.buildDefaultValidatorFactory();

    JobParameterJsonValidator() {
    }

    <PT extends IModelJson> void validateJobParameters(RequestDetails theRequestDetails, @Nonnull JobInstanceStartRequest theStartRequest, @Nonnull JobDefinition<PT> theJobDefinition) {
        Validator validator = this.myValidatorFactory.getValidator();
        PT parameters = theStartRequest.getParameters(theJobDefinition.getParametersType());
        Set constraintErrors = validator.validate(parameters, new Class[0]);
        List errorStrings = constraintErrors.stream().map(t -> t.getPropertyPath() + " - " + t.getMessage()).sorted().collect(Collectors.toList());
        IJobParametersValidator<PT> parametersValidator = theJobDefinition.getParametersValidator();
        if (parametersValidator != null) {
            List outcome = parametersValidator.validate(theRequestDetails, parameters);
            outcome = (List)ObjectUtils.defaultIfNull(outcome, Collections.emptyList());
            errorStrings.addAll(outcome);
        }
        if (!errorStrings.isEmpty()) {
            String message = "Failed to validate parameters for job of type " + theJobDefinition.getJobDefinitionId() + ": " + errorStrings.stream().map(t -> "\n * " + t).collect(Collectors.joining());
            throw new InvalidRequestException(Msg.code((int)2039) + message);
        }
    }
}

