/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.coordinator;

import ca.uhn.fhir.batch2.api.IJobMaintenanceService;
import ca.uhn.fhir.batch2.api.IJobPersistence;
import ca.uhn.fhir.batch2.coordinator.BaseDataSink;
import ca.uhn.fhir.batch2.coordinator.JobDefinitionRegistry;
import ca.uhn.fhir.batch2.coordinator.JobStepExecutorOutput;
import ca.uhn.fhir.batch2.coordinator.WorkChunkProcessor;
import ca.uhn.fhir.batch2.model.JobDefinition;
import ca.uhn.fhir.batch2.model.JobInstance;
import ca.uhn.fhir.batch2.model.JobWorkCursor;
import ca.uhn.fhir.batch2.model.StatusEnum;
import ca.uhn.fhir.batch2.model.WorkChunk;
import ca.uhn.fhir.batch2.progress.JobInstanceStatusUpdater;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.util.Logs;
import java.util.Date;
import javax.annotation.Nonnull;
import org.slf4j.Logger;

public class JobStepExecutor<PT extends IModelJson, IT extends IModelJson, OT extends IModelJson> {
    private static final Logger ourLog = Logs.getBatchTroubleshootingLog();
    private final IJobPersistence myJobPersistence;
    private final WorkChunkProcessor myJobExecutorSvc;
    private final IJobMaintenanceService myJobMaintenanceService;
    private final JobInstanceStatusUpdater myJobInstanceStatusUpdater;
    private final JobDefinition<PT> myDefinition;
    private final JobInstance myInstance;
    private final String myInstanceId;
    private final WorkChunk myWorkChunk;
    private final JobWorkCursor<PT, IT, OT> myCursor;

    JobStepExecutor(@Nonnull IJobPersistence theJobPersistence, @Nonnull JobInstance theInstance, WorkChunk theWorkChunk, @Nonnull JobWorkCursor<PT, IT, OT> theCursor, @Nonnull WorkChunkProcessor theExecutor, @Nonnull IJobMaintenanceService theJobMaintenanceService, @Nonnull JobDefinitionRegistry theJobDefinitionRegistry) {
        this.myJobPersistence = theJobPersistence;
        this.myDefinition = theCursor.jobDefinition;
        this.myInstance = theInstance;
        this.myInstanceId = theInstance.getInstanceId();
        this.myWorkChunk = theWorkChunk;
        this.myCursor = theCursor;
        this.myJobExecutorSvc = theExecutor;
        this.myJobMaintenanceService = theJobMaintenanceService;
        this.myJobInstanceStatusUpdater = new JobInstanceStatusUpdater(theJobDefinitionRegistry);
    }

    public void executeStep() {
        JobStepExecutorOutput<PT, IT, OT> stepExecutorOutput = this.myJobExecutorSvc.doExecution(this.myCursor, this.myInstance, this.myWorkChunk);
        if (!stepExecutorOutput.isSuccessful()) {
            return;
        }
        if (stepExecutorOutput.getDataSink().firstStepProducedNothing()) {
            ourLog.info("First step of job myInstance {} produced no work chunks, marking as completed and setting end date", (Object)this.myInstanceId);
            this.myJobPersistence.updateInstance(this.myInstance.getInstanceId(), instance -> {
                instance.setEndTime(new Date());
                this.myJobInstanceStatusUpdater.updateInstanceStatus(instance, StatusEnum.COMPLETED);
                return true;
            });
        }
        if (this.myInstance.isFastTracking()) {
            this.handleFastTracking(stepExecutorOutput.getDataSink());
        }
    }

    private void handleFastTracking(BaseDataSink<PT, IT, OT> theDataSink) {
        if (theDataSink.getWorkChunkCount() <= 1) {
            ourLog.debug("Gated job {} step {} produced exactly one chunk:  Triggering a maintenance pass.", (Object)this.myDefinition.getJobDefinitionId(), (Object)this.myCursor.currentStep.getStepId());
            boolean success = this.myJobMaintenanceService.triggerMaintenancePass();
            if (!success) {
                this.myJobPersistence.updateInstance(this.myInstance.getInstanceId(), instance -> {
                    instance.setFastTracking(false);
                    return true;
                });
            }
        } else {
            ourLog.debug("Gated job {} step {} produced {} chunks:  Disabling fast tracking.", new Object[]{this.myDefinition.getJobDefinitionId(), this.myCursor.currentStep.getStepId(), theDataSink.getWorkChunkCount()});
            this.myJobPersistence.updateInstance(this.myInstance.getInstanceId(), instance -> {
                instance.setFastTracking(false);
                return true;
            });
        }
    }
}

