/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.step;

import ca.uhn.fhir.batch2.api.IJobDataSink;
import ca.uhn.fhir.batch2.api.IJobStepWorker;
import ca.uhn.fhir.batch2.api.JobExecutionFailedException;
import ca.uhn.fhir.batch2.api.RunOutcome;
import ca.uhn.fhir.batch2.api.StepExecutionDetails;
import ca.uhn.fhir.batch2.jobs.chunk.ChunkRangeJson;
import ca.uhn.fhir.batch2.jobs.chunk.ResourceIdListWorkChunkJson;
import ca.uhn.fhir.batch2.jobs.chunk.TypedPidJson;
import ca.uhn.fhir.batch2.jobs.parameters.PartitionedJobParameters;
import ca.uhn.fhir.batch2.jobs.step.IIdChunkProducer;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.pid.IResourcePidList;
import ca.uhn.fhir.util.Logs;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;

public class ResourceIdListStep<PT extends PartitionedJobParameters, IT extends ChunkRangeJson>
implements IJobStepWorker<PT, IT, ResourceIdListWorkChunkJson> {
    private static final Logger ourLog = Logs.getBatchTroubleshootingLog();
    public static final int DEFAULT_PAGE_SIZE = 20000;
    protected static final int MAX_BATCH_OF_IDS = 500;
    private final IIdChunkProducer<IT> myIdChunkProducer;

    public ResourceIdListStep(IIdChunkProducer<IT> theIdChunkProducer) {
        this.myIdChunkProducer = theIdChunkProducer;
    }

    @Override
    @Nonnull
    public RunOutcome run(@Nonnull StepExecutionDetails<PT, IT> theStepExecutionDetails, @Nonnull IJobDataSink<ResourceIdListWorkChunkJson> theDataSink) throws JobExecutionFailedException {
        IResourcePidList nextChunk;
        ChunkRangeJson data = (ChunkRangeJson)theStepExecutionDetails.getData();
        Date start = data.getStart();
        Date end = data.getEnd();
        Integer batchSize = ((PartitionedJobParameters)theStepExecutionDetails.getParameters()).getBatchSize();
        int pageSize = 20000;
        if (batchSize != null) {
            pageSize = batchSize;
        }
        ourLog.info("Beginning scan for reindex IDs in range {} to {}", (Object)start, (Object)end);
        RequestPartitionId requestPartitionId = ((PartitionedJobParameters)theStepExecutionDetails.getParameters()).getRequestPartitionId();
        int totalIdsFound = 0;
        int chunkCount = 0;
        int maxBatchId = 500;
        if (batchSize != null) {
            maxBatchId = Math.min(batchSize, maxBatchId);
        }
        if ((nextChunk = this.myIdChunkProducer.fetchResourceIdsPage(start, end, pageSize, requestPartitionId, (ChunkRangeJson)theStepExecutionDetails.getData())).isEmpty()) {
            ourLog.info("No data returned");
        }
        ourLog.debug("Found {} IDs from {} to {}", new Object[]{nextChunk.size(), start, nextChunk.getLastDate()});
        Set idBuffer = nextChunk.getTypedResourcePids().stream().map(TypedPidJson::new).collect(Collectors.toCollection(LinkedHashSet::new));
        UnmodifiableIterator partition = Iterators.partition(idBuffer.iterator(), (int)maxBatchId);
        while (partition.hasNext()) {
            List submissionIds = (List)partition.next();
            totalIdsFound += submissionIds.size();
            ++chunkCount;
            this.submitWorkChunk(submissionIds, nextChunk.getRequestPartitionId(), theDataSink);
        }
        ourLog.info("Submitted {} chunks with {} resource IDs", (Object)chunkCount, (Object)totalIdsFound);
        return RunOutcome.SUCCESS;
    }

    private void submitWorkChunk(Collection<TypedPidJson> theTypedPids, RequestPartitionId theRequestPartitionId, IJobDataSink<ResourceIdListWorkChunkJson> theDataSink) {
        if (theTypedPids.isEmpty()) {
            return;
        }
        ourLog.info("Submitting work chunk with {} IDs", (Object)theTypedPids.size());
        ResourceIdListWorkChunkJson data = new ResourceIdListWorkChunkJson(theTypedPids, theRequestPartitionId);
        ourLog.debug("IDs are: {}", (Object)data);
        theDataSink.accept(data);
    }
}

