/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.maintenance;

import ca.uhn.fhir.batch2.api.IJobMaintenanceService;
import ca.uhn.fhir.batch2.api.IJobPersistence;
import ca.uhn.fhir.batch2.api.IReductionStepExecutorService;
import ca.uhn.fhir.batch2.channel.BatchJobSender;
import ca.uhn.fhir.batch2.coordinator.JobDefinitionRegistry;
import ca.uhn.fhir.batch2.coordinator.WorkChunkProcessor;
import ca.uhn.fhir.batch2.maintenance.JobChunkProgressAccumulator;
import ca.uhn.fhir.batch2.maintenance.JobInstanceProcessor;
import ca.uhn.fhir.batch2.model.JobInstance;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.model.sched.HapiJob;
import ca.uhn.fhir.jpa.model.sched.IHasScheduledJobs;
import ca.uhn.fhir.jpa.model.sched.ISchedulerService;
import ca.uhn.fhir.jpa.model.sched.ScheduledJobDefinition;
import ca.uhn.fhir.util.Logs;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.Validate;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class JobMaintenanceServiceImpl
implements IJobMaintenanceService,
IHasScheduledJobs {
    static final Logger ourLog = Logs.getBatchTroubleshootingLog();
    public static final int INSTANCES_PER_PASS = 100;
    public static final String SCHEDULED_JOB_ID = JobMaintenanceScheduledJob.class.getName();
    public static final int MAINTENANCE_TRIGGER_RUN_WITHOUT_SCHEDULER_TIMEOUT = 5;
    private final IJobPersistence myJobPersistence;
    private final ISchedulerService mySchedulerService;
    private final JpaStorageSettings myStorageSettings;
    private final JobDefinitionRegistry myJobDefinitionRegistry;
    private final BatchJobSender myBatchJobSender;
    private final WorkChunkProcessor myJobExecutorSvc;
    private final Semaphore myRunMaintenanceSemaphore = new Semaphore(1);
    private long myScheduledJobFrequencyMillis = 60000L;
    private Runnable myMaintenanceJobStartedCallback = () -> {};
    private Runnable myMaintenanceJobFinishedCallback = () -> {};
    private final IReductionStepExecutorService myReductionStepExecutorService;

    public JobMaintenanceServiceImpl(@Nonnull ISchedulerService theSchedulerService, @Nonnull IJobPersistence theJobPersistence, JpaStorageSettings theStorageSettings, @Nonnull JobDefinitionRegistry theJobDefinitionRegistry, @Nonnull BatchJobSender theBatchJobSender, @Nonnull WorkChunkProcessor theExecutor, @Nonnull IReductionStepExecutorService theReductionStepExecutorService) {
        this.myStorageSettings = theStorageSettings;
        this.myReductionStepExecutorService = theReductionStepExecutorService;
        Validate.notNull((Object)theSchedulerService);
        Validate.notNull((Object)theJobPersistence);
        Validate.notNull((Object)theJobDefinitionRegistry);
        Validate.notNull((Object)theBatchJobSender);
        this.myJobPersistence = theJobPersistence;
        this.mySchedulerService = theSchedulerService;
        this.myJobDefinitionRegistry = theJobDefinitionRegistry;
        this.myBatchJobSender = theBatchJobSender;
        this.myJobExecutorSvc = theExecutor;
    }

    public void scheduleJobs(ISchedulerService theSchedulerService) {
        this.mySchedulerService.scheduleClusteredJob(this.myScheduledJobFrequencyMillis, this.buildJobDefinition());
    }

    @Nonnull
    private ScheduledJobDefinition buildJobDefinition() {
        ScheduledJobDefinition jobDefinition = new ScheduledJobDefinition();
        jobDefinition.setId(SCHEDULED_JOB_ID);
        jobDefinition.setJobClass(JobMaintenanceScheduledJob.class);
        return jobDefinition;
    }

    public void setScheduledJobFrequencyMillis(long theScheduledJobFrequencyMillis) {
        this.myScheduledJobFrequencyMillis = theScheduledJobFrequencyMillis;
    }

    @Override
    public boolean triggerMaintenancePass() {
        if (!this.myStorageSettings.isJobFastTrackingEnabled()) {
            return false;
        }
        if (this.mySchedulerService.isClusteredSchedulingEnabled()) {
            this.mySchedulerService.triggerClusteredJobImmediately(this.buildJobDefinition());
            return true;
        }
        return this.runMaintenanceDirectlyWithTimeout();
    }

    private boolean runMaintenanceDirectlyWithTimeout() {
        if (this.getQueueLength() > 0) {
            ourLog.debug("There are already {} threads waiting to run a maintenance pass.  Ignoring request.", (Object)this.getQueueLength());
            return false;
        }
        try {
            ourLog.debug("There is no clustered scheduling service.  Requesting semaphore to run maintenance pass directly.");
            if (this.myRunMaintenanceSemaphore.tryAcquire(5L, TimeUnit.MINUTES)) {
                ourLog.debug("Semaphore acquired.  Starting maintenance pass.");
                this.doMaintenancePass();
            }
            boolean bl = true;
            return bl;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(Msg.code((int)2134) + "Timed out waiting to run a maintenance pass", e);
        }
        finally {
            ourLog.debug("Maintenance pass complete.  Releasing semaphore.");
            this.myRunMaintenanceSemaphore.release();
        }
    }

    @VisibleForTesting
    int getQueueLength() {
        return this.myRunMaintenanceSemaphore.getQueueLength();
    }

    @Override
    @VisibleForTesting
    public void forceMaintenancePass() {
        ourLog.info("Forcing a maintenance pass run; semaphore at {}", (Object)this.getQueueLength());
        this.doMaintenancePass();
    }

    @Override
    public void runMaintenancePass() {
        if (!this.myRunMaintenanceSemaphore.tryAcquire()) {
            ourLog.debug("Another maintenance pass is already in progress.  Ignoring request.");
            return;
        }
        try {
            ourLog.debug("Maintenance pass starting.");
            this.doMaintenancePass();
        }
        catch (Exception e) {
            ourLog.error("Maintenance pass failed", (Throwable)e);
        }
        finally {
            this.myRunMaintenanceSemaphore.release();
        }
    }

    private void doMaintenancePass() {
        this.myMaintenanceJobStartedCallback.run();
        HashSet<String> processedInstanceIds = new HashSet<String>();
        JobChunkProgressAccumulator progressAccumulator = new JobChunkProgressAccumulator();
        int page = 0;
        while (true) {
            List<JobInstance> instances = this.myJobPersistence.fetchInstances(100, page);
            for (JobInstance instance : instances) {
                String instanceId = instance.getInstanceId();
                if (this.myJobDefinitionRegistry.getJobDefinition(instance.getJobDefinitionId(), instance.getJobDefinitionVersion()).isPresent()) {
                    if (!processedInstanceIds.add(instanceId)) continue;
                    this.myJobDefinitionRegistry.setJobDefinition(instance);
                    JobInstanceProcessor jobInstanceProcessor = new JobInstanceProcessor(this.myJobPersistence, this.myBatchJobSender, instanceId, progressAccumulator, this.myReductionStepExecutorService, this.myJobDefinitionRegistry);
                    ourLog.debug("Triggering maintenance process for instance {} in status {}", (Object)instanceId, (Object)instance.getStatus());
                    jobInstanceProcessor.process();
                    continue;
                }
                ourLog.warn("Job definition {} for instance {} is currently unavailable", (Object)instance.getJobDefinitionId(), (Object)instanceId);
            }
            if (instances.size() < 100) break;
            ++page;
        }
        this.myMaintenanceJobFinishedCallback.run();
    }

    public void setMaintenanceJobStartedCallback(Runnable theMaintenanceJobStartedCallback) {
        this.myMaintenanceJobStartedCallback = theMaintenanceJobStartedCallback;
    }

    public void setMaintenanceJobFinishedCallback(Runnable theMaintenanceJobFinishedCallback) {
        this.myMaintenanceJobFinishedCallback = theMaintenanceJobFinishedCallback;
    }

    public static class JobMaintenanceScheduledJob
    implements HapiJob {
        @Autowired
        private IJobMaintenanceService myTarget;

        public void execute(JobExecutionContext theContext) {
            this.myTarget.runMaintenancePass();
        }
    }
}

