/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.model;

import ca.uhn.fhir.batch2.api.IJobInstance;
import ca.uhn.fhir.batch2.model.JobDefinition;
import ca.uhn.fhir.batch2.model.StatusEnum;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.rest.server.util.JsonDateDeserializer;
import ca.uhn.fhir.rest.server.util.JsonDateSerializer;
import ca.uhn.fhir.util.JsonUtil;
import ca.uhn.fhir.util.Logs;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class JobInstance
implements IModelJson,
IJobInstance {
    @JsonProperty(value="jobDefinitionId")
    private String myJobDefinitionId;
    @JsonProperty(value="parameters")
    private String myParameters;
    @JsonProperty(value="jobDefinitionVersion")
    private int myJobDefinitionVersion;
    @JsonProperty(value="instanceId", access=JsonProperty.Access.READ_ONLY)
    private String myInstanceId;
    @JsonProperty(value="status")
    private StatusEnum myStatus;
    @JsonProperty(value="cancelled")
    private boolean myCancelled;
    @JsonProperty(value="fastTracking")
    private boolean myFastTracking;
    @JsonProperty(value="createTime")
    @JsonSerialize(using=JsonDateSerializer.class)
    @JsonDeserialize(using=JsonDateDeserializer.class)
    private Date myCreateTime;
    @JsonProperty(value="startTime")
    @JsonSerialize(using=JsonDateSerializer.class)
    @JsonDeserialize(using=JsonDateDeserializer.class)
    private Date myStartTime;
    @JsonProperty(value="endTime")
    @JsonSerialize(using=JsonDateSerializer.class)
    @JsonDeserialize(using=JsonDateDeserializer.class)
    private Date myEndTime;
    @JsonProperty(value="updateTime")
    @JsonSerialize(using=JsonDateSerializer.class)
    @JsonDeserialize(using=JsonDateDeserializer.class)
    private Date myUpdateTime;
    @JsonProperty(value="combinedRecordsProcessed")
    private Integer myCombinedRecordsProcessed;
    @JsonProperty(value="combinedRecordsProcessedPerSecond")
    private Double myCombinedRecordsProcessedPerSecond;
    @JsonProperty(value="totalElapsedMillis")
    private Integer myTotalElapsedMillis;
    @JsonProperty(value="workChunksPurged", access=JsonProperty.Access.READ_ONLY)
    private boolean myWorkChunksPurged;
    @JsonProperty(value="progress", access=JsonProperty.Access.READ_ONLY)
    private double myProgress;
    @JsonProperty(value="currentGatedStepId", access=JsonProperty.Access.READ_ONLY)
    private String myCurrentGatedStepId;
    @JsonProperty(value="errorMessage", access=JsonProperty.Access.READ_ONLY)
    private String myErrorMessage;
    @JsonProperty(value="errorCount", access=JsonProperty.Access.READ_ONLY)
    private int myErrorCount;
    @JsonProperty(value="estimatedCompletion", access=JsonProperty.Access.READ_ONLY)
    private String myEstimatedTimeRemaining;
    @JsonProperty(value="report", access=JsonProperty.Access.READ_WRITE)
    private String myReport;
    @JsonProperty(value="warningMessages", access=JsonProperty.Access.READ_ONLY)
    private String myWarningMessages;

    public JobInstance() {
    }

    public JobInstance(JobInstance theJobInstance) {
        this.setJobDefinitionId(theJobInstance.getJobDefinitionId());
        this.setParameters(theJobInstance.getParameters());
        this.setCancelled(theJobInstance.isCancelled());
        this.setFastTracking(theJobInstance.isFastTracking());
        this.setCombinedRecordsProcessed(theJobInstance.getCombinedRecordsProcessed());
        this.setCombinedRecordsProcessedPerSecond(theJobInstance.getCombinedRecordsProcessedPerSecond());
        this.setCreateTime(theJobInstance.getCreateTime());
        this.setEndTime(theJobInstance.getEndTime());
        this.setUpdateTime(theJobInstance.getUpdateTime());
        this.setErrorCount(theJobInstance.getErrorCount());
        this.setErrorMessage(theJobInstance.getErrorMessage());
        this.setEstimatedTimeRemaining(theJobInstance.getEstimatedTimeRemaining());
        this.setInstanceId(theJobInstance.getInstanceId());
        this.setJobDefinitionVersion(theJobInstance.getJobDefinitionVersion());
        this.setProgress(theJobInstance.getProgress());
        this.setStartTime(theJobInstance.getStartTime());
        this.setStatus(theJobInstance.getStatus());
        this.setTotalElapsedMillis(theJobInstance.getTotalElapsedMillis());
        this.setWorkChunksPurged(theJobInstance.isWorkChunksPurged());
        this.setCurrentGatedStepId(theJobInstance.getCurrentGatedStepId());
        this.setReport(theJobInstance.getReport());
        this.setWarningMessages(theJobInstance.getWarningMessages());
    }

    public String getJobDefinitionId() {
        return this.myJobDefinitionId;
    }

    public void setJobDefinitionId(String theJobDefinitionId) {
        this.myJobDefinitionId = theJobDefinitionId;
    }

    public String getParameters() {
        return this.myParameters;
    }

    public void setParameters(String theParameters) {
        this.myParameters = theParameters;
    }

    public <T extends IModelJson> T getParameters(Class<T> theType) {
        if (this.myParameters == null) {
            return null;
        }
        return (T)((IModelJson)JsonUtil.deserialize((String)this.myParameters, theType));
    }

    public void setParameters(IModelJson theParameters) {
        this.myParameters = JsonUtil.serializeOrInvalidRequest((IModelJson)theParameters);
    }

    public void setUpdateTime(Date theUpdateTime) {
        this.myUpdateTime = theUpdateTime;
    }

    public Date getUpdateTime() {
        return this.myUpdateTime;
    }

    public static JobInstance fromJobDefinition(JobDefinition<?> theJobDefinition) {
        JobInstance instance = new JobInstance();
        instance.setJobDefinition(theJobDefinition);
        if (theJobDefinition.isGatedExecution()) {
            instance.setFastTracking(true);
            instance.setCurrentGatedStepId(theJobDefinition.getFirstStepId());
        }
        return instance;
    }

    public static JobInstance fromInstanceId(String theInstanceId) {
        JobInstance instance = new JobInstance();
        instance.setInstanceId(theInstanceId);
        return instance;
    }

    @Override
    public String getCurrentGatedStepId() {
        return this.myCurrentGatedStepId;
    }

    public void setCurrentGatedStepId(String theCurrentGatedStepId) {
        this.myCurrentGatedStepId = theCurrentGatedStepId;
    }

    @Override
    public int getErrorCount() {
        return this.myErrorCount;
    }

    public JobInstance setErrorCount(int theErrorCount) {
        this.myErrorCount = theErrorCount;
        return this;
    }

    @Override
    public String getEstimatedTimeRemaining() {
        return this.myEstimatedTimeRemaining;
    }

    public void setEstimatedTimeRemaining(String theEstimatedTimeRemaining) {
        this.myEstimatedTimeRemaining = theEstimatedTimeRemaining;
    }

    @Override
    public boolean isWorkChunksPurged() {
        return this.myWorkChunksPurged;
    }

    public void setWorkChunksPurged(boolean theWorkChunksPurged) {
        this.myWorkChunksPurged = theWorkChunksPurged;
    }

    @Override
    public StatusEnum getStatus() {
        return this.myStatus;
    }

    public JobInstance setStatus(StatusEnum theStatus) {
        this.myStatus = theStatus;
        return this;
    }

    @Override
    public int getJobDefinitionVersion() {
        return this.myJobDefinitionVersion;
    }

    public void setJobDefinitionVersion(int theJobDefinitionVersion) {
        this.myJobDefinitionVersion = theJobDefinitionVersion;
    }

    @Override
    public String getInstanceId() {
        return this.myInstanceId;
    }

    public void setInstanceId(String theInstanceId) {
        this.myInstanceId = theInstanceId;
    }

    @Override
    public Date getStartTime() {
        return this.myStartTime;
    }

    public JobInstance setStartTime(Date theStartTime) {
        this.myStartTime = theStartTime;
        return this;
    }

    @Override
    public Date getEndTime() {
        return this.myEndTime;
    }

    public JobInstance setEndTime(Date theEndTime) {
        this.myEndTime = theEndTime;
        return this;
    }

    @Override
    public Integer getCombinedRecordsProcessed() {
        return this.myCombinedRecordsProcessed;
    }

    public void setCombinedRecordsProcessed(Integer theCombinedRecordsProcessed) {
        this.myCombinedRecordsProcessed = theCombinedRecordsProcessed;
    }

    @Override
    public Double getCombinedRecordsProcessedPerSecond() {
        return this.myCombinedRecordsProcessedPerSecond;
    }

    public void setCombinedRecordsProcessedPerSecond(Double theCombinedRecordsProcessedPerSecond) {
        this.myCombinedRecordsProcessedPerSecond = theCombinedRecordsProcessedPerSecond;
    }

    @Override
    public Date getCreateTime() {
        return this.myCreateTime;
    }

    public JobInstance setCreateTime(Date theCreateTime) {
        this.myCreateTime = theCreateTime;
        return this;
    }

    @Override
    public Integer getTotalElapsedMillis() {
        return this.myTotalElapsedMillis;
    }

    public void setTotalElapsedMillis(Integer theTotalElapsedMillis) {
        this.myTotalElapsedMillis = theTotalElapsedMillis;
    }

    @Override
    public double getProgress() {
        return this.myProgress;
    }

    public void setProgress(double theProgress) {
        this.myProgress = theProgress;
    }

    @Override
    public String getErrorMessage() {
        return this.myErrorMessage;
    }

    public JobInstance setErrorMessage(String theErrorMessage) {
        this.myErrorMessage = theErrorMessage;
        return this;
    }

    @Override
    public String getWarningMessages() {
        return this.myWarningMessages;
    }

    public JobInstance setWarningMessages(String theWarningMessages) {
        this.myWarningMessages = theWarningMessages;
        return this;
    }

    public void setJobDefinition(JobDefinition<?> theJobDefinition) {
        this.setJobDefinitionId(theJobDefinition.getJobDefinitionId());
        this.setJobDefinitionVersion(theJobDefinition.getJobDefinitionVersion());
    }

    @Override
    public boolean isCancelled() {
        return this.myCancelled;
    }

    public void setCancelled(boolean theCancelled) {
        this.myCancelled = theCancelled;
    }

    @Override
    public String getReport() {
        return this.myReport;
    }

    public void setReport(String theReport) {
        this.myReport = theReport;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("jobDefinitionId", (Object)(this.getJobDefinitionId() + "/" + this.myJobDefinitionVersion)).append("instanceId", (Object)this.myInstanceId).append("status", (Object)this.myStatus).append("myCancelled", this.myCancelled).append("createTime", (Object)this.myCreateTime).append("startTime", (Object)this.myStartTime).append("endTime", (Object)this.myEndTime).append("updateTime", (Object)this.myUpdateTime).append("combinedRecordsProcessed", (Object)this.myCombinedRecordsProcessed).append("combinedRecordsProcessedPerSecond", (Object)this.myCombinedRecordsProcessedPerSecond).append("totalElapsedMillis", (Object)this.myTotalElapsedMillis).append("workChunksPurged", this.myWorkChunksPurged).append("progress", this.myProgress).append("errorMessage", (Object)this.myErrorMessage).append("errorCount", this.myErrorCount).append("estimatedTimeRemaining", (Object)this.myEstimatedTimeRemaining).append("report", (Object)this.myReport).append("warningMessages", (Object)this.myWarningMessages).toString();
    }

    public boolean isRunning() {
        if (this.isCancelled()) {
            return false;
        }
        switch (this.getStatus()) {
            case IN_PROGRESS: 
            case ERRORED: 
            case FINALIZE: {
                return true;
            }
        }
        Logs.getBatchTroubleshootingLog().debug("Status {} is considered \"not running\"", (Object)this.myStatus);
        return false;
    }

    public boolean isFinished() {
        return this.myStatus == StatusEnum.COMPLETED || this.myStatus == StatusEnum.FAILED || this.myStatus == StatusEnum.CANCELLED;
    }

    public boolean hasGatedStep() {
        return !StringUtils.isBlank((CharSequence)this.myCurrentGatedStepId);
    }

    public boolean isPendingCancellationRequest() {
        return this.myCancelled && this.myStatus.isCancellable();
    }

    @Override
    public boolean isFastTracking() {
        return this.myFastTracking;
    }

    @Override
    public void setFastTracking(boolean theFastTracking) {
        this.myFastTracking = theFastTracking;
    }
}

