/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.model;

import ca.uhn.fhir.batch2.api.VoidModel;
import ca.uhn.fhir.batch2.model.JobDefinition;
import ca.uhn.fhir.batch2.model.JobDefinitionStep;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.Logs;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public class JobWorkCursor<PT extends IModelJson, IT extends IModelJson, OT extends IModelJson> {
    private static final Logger ourLog = Logs.getBatchTroubleshootingLog();
    public final JobDefinition<PT> jobDefinition;
    public final boolean isFirstStep;
    public final JobDefinitionStep<PT, IT, OT> currentStep;
    public final JobDefinitionStep<PT, OT, ?> nextStep;

    public JobWorkCursor(JobDefinition<PT> theJobDefinition, boolean theIsFirstStep, JobDefinitionStep<PT, IT, OT> theCurrentStep, JobDefinitionStep<PT, OT, ?> theNextStep) {
        this.jobDefinition = theJobDefinition;
        this.isFirstStep = theIsFirstStep;
        this.currentStep = theCurrentStep;
        this.nextStep = theNextStep;
        this.validate();
    }

    private void validate() {
        if (this.isFirstStep) {
            Validate.isTrue((this.currentStep.getInputType() == VoidModel.class ? 1 : 0) != 0);
        }
        if (this.nextStep != null) {
            Validate.isTrue((this.currentStep.getOutputType() == this.nextStep.getInputType() ? 1 : 0) != 0);
        }
    }

    public static <PT extends IModelJson> JobWorkCursor<PT, ?, ?> fromJobDefinitionAndRequestedStepId(JobDefinition<PT> theJobDefinition, String theRequestedStepId) {
        boolean isFirstStep = false;
        JobDefinitionStep<PT, ?, ?> currentStep = null;
        JobDefinitionStep<PT, ?, ?> nextStep = null;
        List<JobDefinitionStep<PT, ?, ?>> steps = theJobDefinition.getSteps();
        for (int i = 0; i < steps.size(); ++i) {
            JobDefinitionStep<PT, ?, ?> step = steps.get(i);
            if (!step.getStepId().equals(theRequestedStepId)) continue;
            currentStep = step;
            if (i == 0) {
                isFirstStep = true;
            }
            if (i >= steps.size() - 1) break;
            nextStep = steps.get(i + 1);
            break;
        }
        if (currentStep == null) {
            String msg = "Unknown step[" + theRequestedStepId + "] for job definition ID[" + theJobDefinition.getJobDefinitionId() + "] version[" + theJobDefinition.getJobDefinitionVersion() + "]";
            ourLog.warn(msg);
            throw new InternalErrorException(Msg.code((int)2042) + msg);
        }
        return new JobWorkCursor(theJobDefinition, isFirstStep, currentStep, nextStep);
    }

    public String getCurrentStepId() {
        return this.currentStep.getStepId();
    }

    public boolean isFinalStep() {
        return this.nextStep == null;
    }

    public JobWorkCursor<PT, IT, VoidModel> asFinalCursor() {
        Validate.isTrue((boolean)this.isFinalStep());
        return this;
    }

    public JobDefinition<PT> getJobDefinition() {
        return this.jobDefinition;
    }

    public JobDefinitionStep<PT, IT, OT> getCurrentStep() {
        return this.currentStep;
    }

    public boolean isReductionStep() {
        return this.currentStep.isReductionStep();
    }
}

