/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.model;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.util.Logs;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;

public enum StatusEnum {
    QUEUED(true, false, true),
    IN_PROGRESS(true, false, true),
    FINALIZE(true, false, true),
    COMPLETED(false, true, false),
    ERRORED(true, false, true),
    FAILED(true, true, false),
    CANCELLED(true, true, false);

    private static final Logger ourLog;
    static final Map<StatusEnum, Set<StatusEnum>> ourFromStates;
    static final Map<StatusEnum, Set<StatusEnum>> ourToStates;
    private final boolean myIncomplete;
    private final boolean myEnded;
    private final boolean myIsCancellable;
    private static StatusEnum[] ourIncompleteStatuses;
    private static Set<StatusEnum> ourEndedStatuses;
    private static Set<StatusEnum> ourNotEndedStatuses;

    private StatusEnum(boolean theIncomplete, boolean theEnded, boolean theIsCancellable) {
        this.myIncomplete = theIncomplete;
        this.myEnded = theEnded;
        this.myIsCancellable = theIsCancellable;
    }

    public static StatusEnum[] getIncompleteStatuses() {
        StatusEnum[] retVal = ourIncompleteStatuses;
        if (retVal == null) {
            EnumSet<StatusEnum> incompleteSet = EnumSet.noneOf(StatusEnum.class);
            for (StatusEnum next : StatusEnum.values()) {
                if (!next.myIncomplete) continue;
                incompleteSet.add(next);
            }
            ourIncompleteStatuses = incompleteSet.toArray(new StatusEnum[0]);
            retVal = ourIncompleteStatuses;
        }
        return retVal;
    }

    @Nonnull
    public static Set<StatusEnum> getEndedStatuses() {
        Set<StatusEnum> retVal = ourEndedStatuses;
        if (retVal == null) {
            StatusEnum.initializeStaticEndedStatuses();
        }
        retVal = ourEndedStatuses;
        return retVal;
    }

    @Nonnull
    public static Set<StatusEnum> getNotEndedStatuses() {
        Set<StatusEnum> retVal = ourNotEndedStatuses;
        if (retVal == null) {
            StatusEnum.initializeStaticEndedStatuses();
        }
        retVal = ourNotEndedStatuses;
        return retVal;
    }

    private static void initializeStaticEndedStatuses() {
        EnumSet<StatusEnum> endedSet = EnumSet.noneOf(StatusEnum.class);
        EnumSet<StatusEnum> notEndedSet = EnumSet.noneOf(StatusEnum.class);
        for (StatusEnum next : StatusEnum.values()) {
            if (next.myEnded) {
                endedSet.add(next);
                continue;
            }
            notEndedSet.add(next);
        }
        ourEndedStatuses = Collections.unmodifiableSet(endedSet);
        ourNotEndedStatuses = Collections.unmodifiableSet(notEndedSet);
    }

    public static boolean isLegalStateTransition(StatusEnum theOrigStatus, StatusEnum theNewStatus) {
        boolean canTransition;
        switch (theOrigStatus) {
            case QUEUED: {
                canTransition = true;
                break;
            }
            case IN_PROGRESS: 
            case ERRORED: {
                canTransition = theNewStatus != QUEUED;
                break;
            }
            case CANCELLED: {
                canTransition = false;
                break;
            }
            case COMPLETED: {
                canTransition = false;
                break;
            }
            case FAILED: {
                canTransition = theNewStatus == FAILED;
                break;
            }
            case FINALIZE: {
                canTransition = theNewStatus != QUEUED && theNewStatus != IN_PROGRESS;
                break;
            }
            default: {
                throw new IllegalStateException(Msg.code((int)2131) + "Unknown batch state " + theOrigStatus);
            }
        }
        if (!canTransition) {
            ourLog.debug("Tried to execute an illegal state transition. [origStatus={}, newStatus={}]", (Object)theOrigStatus, (Object)theNewStatus);
        }
        return canTransition;
    }

    public boolean isIncomplete() {
        return this.myIncomplete;
    }

    public boolean isEnded() {
        return this.myEnded;
    }

    public boolean isCancellable() {
        return this.myIsCancellable;
    }

    public Set<StatusEnum> getPriorStates() {
        return ourFromStates.get((Object)this);
    }

    public Set<StatusEnum> getNextStates() {
        return ourToStates.get((Object)this);
    }

    static {
        ourLog = Logs.getBatchTroubleshootingLog();
        EnumMap<StatusEnum, EnumSet<StatusEnum>> fromStates = new EnumMap<StatusEnum, EnumSet<StatusEnum>>(StatusEnum.class);
        EnumMap<StatusEnum, EnumSet<StatusEnum>> toStates = new EnumMap<StatusEnum, EnumSet<StatusEnum>>(StatusEnum.class);
        for (StatusEnum nextEnum : StatusEnum.values()) {
            fromStates.put(nextEnum, EnumSet.noneOf(StatusEnum.class));
            toStates.put(nextEnum, EnumSet.noneOf(StatusEnum.class));
        }
        for (StatusEnum nextPriorEnum : StatusEnum.values()) {
            for (StatusEnum nextNextEnum : StatusEnum.values()) {
                if (!StatusEnum.isLegalStateTransition(nextPriorEnum, nextNextEnum)) continue;
                ((Set)fromStates.get((Object)nextNextEnum)).add(nextPriorEnum);
                ((Set)toStates.get((Object)nextPriorEnum)).add(nextNextEnum);
            }
        }
        ourFromStates = Maps.immutableEnumMap(fromStates);
        ourToStates = Maps.immutableEnumMap(toStates);
    }
}

