/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.progress;

import ca.uhn.fhir.batch2.model.JobInstance;
import ca.uhn.fhir.batch2.model.StatusEnum;
import ca.uhn.fhir.batch2.model.WorkChunk;
import ca.uhn.fhir.batch2.model.WorkChunkStatusEnum;
import ca.uhn.fhir.util.Logs;
import ca.uhn.fhir.util.StopWatch;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;

public class InstanceProgress {
    private static final Logger ourLog = Logs.getBatchTroubleshootingLog();
    private int myRecordsProcessed = 0;
    private int myIncompleteChunkCount = 0;
    private int myCompleteChunkCount = 0;
    private int myErroredChunkCount = 0;
    private int myFailedChunkCount = 0;
    private int myErrorCountForAllStatuses = 0;
    private Date myEarliestStartTime = null;
    private Date myLatestEndTime = null;
    private String myErrormessage = null;
    private StatusEnum myNewStatus = null;
    private final Map<String, Map<WorkChunkStatusEnum, Integer>> myStepToStatusCountMap = new HashMap<String, Map<WorkChunkStatusEnum, Integer>>();
    private final Set<String> myWarningMessages = new HashSet<String>();

    public void addChunk(WorkChunk theChunk) {
        this.myErrorCountForAllStatuses += theChunk.getErrorCount();
        if (theChunk.getWarningMessage() != null) {
            this.myWarningMessages.add(theChunk.getWarningMessage());
        }
        this.updateRecordsProcessed(theChunk);
        this.updateEarliestTime(theChunk);
        this.updateLatestEndTime(theChunk);
        this.updateCompletionStatus(theChunk);
    }

    private void updateCompletionStatus(WorkChunk theChunk) {
        Map statusToCountMap = this.myStepToStatusCountMap.getOrDefault(theChunk.getTargetStepId(), new HashMap());
        statusToCountMap.put(theChunk.getStatus(), statusToCountMap.getOrDefault((Object)theChunk.getStatus(), 0) + 1);
        switch (theChunk.getStatus()) {
            case QUEUED: 
            case IN_PROGRESS: {
                ++this.myIncompleteChunkCount;
                break;
            }
            case COMPLETED: {
                ++this.myCompleteChunkCount;
                break;
            }
            case ERRORED: {
                ++this.myErroredChunkCount;
                if (this.myErrormessage != null) break;
                this.myErrormessage = theChunk.getErrorMessage();
                break;
            }
            case FAILED: {
                ++this.myFailedChunkCount;
                this.myErrormessage = theChunk.getErrorMessage();
            }
        }
        ourLog.trace("Chunk has status {} with errored chunk count {}", (Object)theChunk.getStatus(), (Object)this.myErroredChunkCount);
    }

    private void updateLatestEndTime(WorkChunk theChunk) {
        if (theChunk.getEndTime() != null && (this.myLatestEndTime == null || this.myLatestEndTime.before(theChunk.getEndTime()))) {
            this.myLatestEndTime = theChunk.getEndTime();
        }
    }

    private void updateEarliestTime(WorkChunk theChunk) {
        if (theChunk.getStartTime() != null && (this.myEarliestStartTime == null || this.myEarliestStartTime.after(theChunk.getStartTime()))) {
            this.myEarliestStartTime = theChunk.getStartTime();
        }
    }

    private void updateRecordsProcessed(WorkChunk theChunk) {
        if (theChunk.getRecordsProcessed() != null) {
            this.myRecordsProcessed += theChunk.getRecordsProcessed().intValue();
        }
    }

    public void updateInstanceForReductionStep(JobInstance theInstance) {
        this.updateInstance(theInstance, true);
    }

    public void updateInstance(JobInstance theInstance) {
        this.updateInstance(theInstance, false);
        String newWarningMessage = StringUtils.right((String)String.join((CharSequence)"\n", this.myWarningMessages), (int)4000);
        theInstance.setWarningMessages(newWarningMessage);
    }

    public void updateInstance(JobInstance theInstance, boolean theCalledFromReducer) {
        long elapsedTime;
        ourLog.debug("updateInstance {}: {}", (Object)theInstance.getInstanceId(), (Object)this);
        if (this.myEarliestStartTime != null) {
            theInstance.setStartTime(this.myEarliestStartTime);
        }
        if (this.myLatestEndTime != null && this.hasNewStatus() && this.myNewStatus.isEnded()) {
            theInstance.setEndTime(this.myLatestEndTime);
        }
        theInstance.setErrorCount(this.myErrorCountForAllStatuses);
        theInstance.setCombinedRecordsProcessed(this.myRecordsProcessed);
        if (this.getChunkCount() > 0) {
            int chunkCount = this.getChunkCount();
            int conditionalChunkCount = theCalledFromReducer ? chunkCount - this.myIncompleteChunkCount : chunkCount;
            double percentComplete = (double)this.myCompleteChunkCount / (double)conditionalChunkCount;
            theInstance.setProgress(percentComplete);
        }
        if (this.myEarliestStartTime != null && this.myLatestEndTime != null && (elapsedTime = this.myLatestEndTime.getTime() - this.myEarliestStartTime.getTime()) > 0L) {
            double throughput = StopWatch.getThroughput((long)this.myRecordsProcessed, (long)elapsedTime, (TimeUnit)TimeUnit.SECONDS);
            theInstance.setCombinedRecordsProcessedPerSecond(throughput);
            String estimatedTimeRemaining = StopWatch.formatEstimatedTimeRemaining((double)this.myCompleteChunkCount, (double)this.getChunkCount(), (double)elapsedTime);
            theInstance.setEstimatedTimeRemaining(estimatedTimeRemaining);
        }
        theInstance.setErrorMessage(this.myErrormessage);
        if (this.hasNewStatus()) {
            ourLog.trace("Status will change for {}: {}", (Object)theInstance.getInstanceId(), (Object)this.myNewStatus);
        }
        ourLog.trace("Updating status for instance with errors: {}", (Object)this.myErroredChunkCount);
        ourLog.trace("Statistics for job {}: complete/in-progress/errored/failed chunk count {}/{}/{}/{}", new Object[]{theInstance.getInstanceId(), this.myCompleteChunkCount, this.myIncompleteChunkCount, this.myErroredChunkCount, this.myFailedChunkCount});
    }

    private int getChunkCount() {
        return this.myIncompleteChunkCount + this.myCompleteChunkCount + this.myFailedChunkCount + this.myErroredChunkCount;
    }

    public void calculateNewStatus() {
        if (this.myFailedChunkCount > 0) {
            this.myNewStatus = StatusEnum.FAILED;
        } else if (this.myErroredChunkCount > 0) {
            this.myNewStatus = StatusEnum.ERRORED;
        } else if (this.myIncompleteChunkCount == 0 && this.myCompleteChunkCount > 0) {
            this.myNewStatus = StatusEnum.COMPLETED;
        }
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this).append("myIncompleteChunkCount", this.myIncompleteChunkCount).append("myCompleteChunkCount", this.myCompleteChunkCount).append("myErroredChunkCount", this.myErroredChunkCount).append("myFailedChunkCount", this.myFailedChunkCount).append("myErrormessage", (Object)this.myErrormessage).append("myRecordsProcessed", this.myRecordsProcessed);
        builder.append("myStepToStatusCountMap", this.myStepToStatusCountMap);
        return builder.toString();
    }

    public StatusEnum getNewStatus() {
        return this.myNewStatus;
    }

    public boolean hasNewStatus() {
        return this.myNewStatus != null;
    }
}

