/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.progress;

import ca.uhn.fhir.batch2.api.IJobPersistence;
import ca.uhn.fhir.batch2.coordinator.JobDefinitionRegistry;
import ca.uhn.fhir.batch2.maintenance.JobChunkProgressAccumulator;
import ca.uhn.fhir.batch2.model.WorkChunk;
import ca.uhn.fhir.batch2.progress.InstanceProgress;
import ca.uhn.fhir.batch2.progress.JobInstanceStatusUpdater;
import ca.uhn.fhir.util.Logs;
import ca.uhn.fhir.util.StopWatch;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.slf4j.Logger;

public class JobInstanceProgressCalculator {
    private static final Logger ourLog = Logs.getBatchTroubleshootingLog();
    private final IJobPersistence myJobPersistence;
    private final JobChunkProgressAccumulator myProgressAccumulator;
    private final JobInstanceStatusUpdater myJobInstanceStatusUpdater;

    public JobInstanceProgressCalculator(IJobPersistence theJobPersistence, JobChunkProgressAccumulator theProgressAccumulator, JobDefinitionRegistry theJobDefinitionRegistry) {
        this.myJobPersistence = theJobPersistence;
        this.myProgressAccumulator = theProgressAccumulator;
        this.myJobInstanceStatusUpdater = new JobInstanceStatusUpdater(theJobDefinitionRegistry);
    }

    public void calculateAndStoreInstanceProgress(String theInstanceId) {
        StopWatch stopWatch = new StopWatch();
        ourLog.trace("calculating progress: {}", (Object)theInstanceId);
        InstanceProgress instanceProgress = this.calculateInstanceProgress(theInstanceId);
        this.myJobPersistence.updateInstance(theInstanceId, currentInstance -> {
            instanceProgress.updateInstance(currentInstance);
            if (currentInstance.getCombinedRecordsProcessed() > 0) {
                ourLog.info("Job {} of type {} has status {} - {} records processed ({}/sec) - ETA: {}", new Object[]{currentInstance.getInstanceId(), currentInstance.getJobDefinitionId(), currentInstance.getStatus(), currentInstance.getCombinedRecordsProcessed(), currentInstance.getCombinedRecordsProcessedPerSecond(), currentInstance.getEstimatedTimeRemaining()});
            } else {
                ourLog.info("Job {} of type {} has status {} - {} records processed", new Object[]{currentInstance.getInstanceId(), currentInstance.getJobDefinitionId(), currentInstance.getStatus(), currentInstance.getCombinedRecordsProcessed()});
            }
            ourLog.debug(instanceProgress.toString());
            if (instanceProgress.hasNewStatus()) {
                this.myJobInstanceStatusUpdater.updateInstanceStatus(currentInstance, instanceProgress.getNewStatus());
            }
            return true;
        });
        ourLog.trace("calculating progress: {} - complete in {}", (Object)theInstanceId, (Object)stopWatch);
    }

    @Nonnull
    public InstanceProgress calculateInstanceProgress(String instanceId) {
        InstanceProgress instanceProgress = new InstanceProgress();
        Iterator<WorkChunk> workChunkIterator = this.myJobPersistence.fetchAllWorkChunksIterator(instanceId, false);
        while (workChunkIterator.hasNext()) {
            WorkChunk next = workChunkIterator.next();
            this.myProgressAccumulator.addChunk(next);
            instanceProgress.addChunk(next);
        }
        instanceProgress.calculateNewStatus();
        return instanceProgress;
    }
}

