/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.api;

import ca.uhn.fhir.batch2.api.IWorkChunkPersistence;
import ca.uhn.fhir.batch2.api.JobOperationResultJson;
import ca.uhn.fhir.batch2.model.FetchJobInstancesRequest;
import ca.uhn.fhir.batch2.model.JobDefinition;
import ca.uhn.fhir.batch2.model.JobInstance;
import ca.uhn.fhir.batch2.model.StatusEnum;
import ca.uhn.fhir.batch2.model.WorkChunk;
import ca.uhn.fhir.batch2.model.WorkChunkCreateEvent;
import ca.uhn.fhir.batch2.models.JobInstanceFetchRequest;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public interface IJobPersistence
extends IWorkChunkPersistence {
    public static final Logger ourLog = LoggerFactory.getLogger(IJobPersistence.class);

    @Transactional(propagation=Propagation.REQUIRED)
    public String storeNewInstance(JobInstance var1);

    public Optional<JobInstance> fetchInstance(String var1);

    public List<JobInstance> fetchInstances(String var1, Set<StatusEnum> var2, Date var3, Pageable var4);

    public List<JobInstance> fetchInstances(FetchJobInstancesRequest var1, int var2, int var3);

    public List<JobInstance> fetchInstances(int var1, int var2);

    public List<JobInstance> fetchRecentInstances(int var1, int var2);

    public List<JobInstance> fetchInstancesByJobDefinitionIdAndStatus(String var1, Set<StatusEnum> var2, int var3, int var4);

    public List<JobInstance> fetchInstancesByJobDefinitionId(String var1, int var2, int var3);

    public Page<JobInstance> fetchJobInstances(JobInstanceFetchRequest var1);

    public boolean canAdvanceInstanceToNextStep(String var1, String var2);

    @Override
    public Iterator<WorkChunk> fetchAllWorkChunksIterator(String var1, boolean var2);

    @Override
    public Stream<WorkChunk> fetchAllWorkChunksForStepStream(String var1, String var2);

    @Transactional
    public boolean updateInstance(String var1, JobInstanceUpdateCallback var2);

    public void deleteInstanceAndChunks(String var1);

    public void deleteChunksAndMarkInstanceAsChunksPurged(String var1);

    @Transactional(propagation=Propagation.MANDATORY)
    public boolean markInstanceAsStatusWhenStatusIn(String var1, StatusEnum var2, Set<StatusEnum> var3);

    public JobOperationResultJson cancelInstance(String var1);

    @Transactional(propagation=Propagation.MANDATORY)
    public void updateInstanceUpdateTime(String var1);

    @Nonnull
    @Transactional(propagation=Propagation.MANDATORY)
    default public CreateResult onCreateWithFirstChunk(JobDefinition<?> theJobDefinition, String theParameters) {
        JobInstance instance = JobInstance.fromJobDefinition(theJobDefinition);
        instance.setParameters(theParameters);
        instance.setStatus(StatusEnum.QUEUED);
        String instanceId = this.storeNewInstance(instance);
        ourLog.info("Stored new {} job {} with status {}", new Object[]{theJobDefinition.getJobDefinitionId(), instanceId, instance.getStatus()});
        ourLog.debug("Job parameters: {}", (Object)instance.getParameters());
        WorkChunkCreateEvent batchWorkChunk = WorkChunkCreateEvent.firstChunk(theJobDefinition, instanceId);
        String chunkId = this.onWorkChunkCreate(batchWorkChunk);
        return new CreateResult(instanceId, chunkId);
    }

    @Transactional(propagation=Propagation.MANDATORY)
    default public boolean onChunkDequeued(String theJobInstanceId) {
        return this.markInstanceAsStatusWhenStatusIn(theJobInstanceId, StatusEnum.IN_PROGRESS, Collections.singleton(StatusEnum.QUEUED));
    }

    public static class CreateResult {
        public final String jobInstanceId;
        public final String workChunkId;

        public CreateResult(String theJobInstanceId, String theWorkChunkId) {
            this.jobInstanceId = theJobInstanceId;
            this.workChunkId = theWorkChunkId;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("jobInstanceId", (Object)this.jobInstanceId).append("workChunkId", (Object)this.workChunkId).toString();
        }
    }

    public static interface JobInstanceUpdateCallback {
        public boolean doUpdate(JobInstance var1);
    }
}

