/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.api;

import ca.uhn.fhir.batch2.model.WorkChunk;
import ca.uhn.fhir.batch2.model.WorkChunkCompletionEvent;
import ca.uhn.fhir.batch2.model.WorkChunkCreateEvent;
import ca.uhn.fhir.batch2.model.WorkChunkErrorEvent;
import ca.uhn.fhir.batch2.model.WorkChunkStatusEnum;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public interface IWorkChunkPersistence {
    public String onWorkChunkCreate(WorkChunkCreateEvent var1);

    @Transactional(propagation=Propagation.MANDATORY)
    public Optional<WorkChunk> onWorkChunkDequeue(String var1);

    public WorkChunkStatusEnum onWorkChunkError(WorkChunkErrorEvent var1);

    @Transactional(propagation=Propagation.REQUIRED)
    public void onWorkChunkFailed(String var1, String var2);

    @Transactional(propagation=Propagation.REQUIRED)
    public void onWorkChunkCompletion(WorkChunkCompletionEvent var1);

    @Transactional(propagation=Propagation.MANDATORY)
    public void markWorkChunksWithStatusAndWipeData(String var1, List<String> var2, WorkChunkStatusEnum var3, String var4);

    public Iterator<WorkChunk> fetchAllWorkChunksIterator(String var1, boolean var2);

    @Transactional(propagation=Propagation.MANDATORY, readOnly=true)
    public Stream<WorkChunk> fetchAllWorkChunksForStepStream(String var1, String var2);

    public List<String> fetchAllChunkIdsForStepWithStatus(String var1, String var2, WorkChunkStatusEnum var3);
}

