/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.coordinator;

import ca.uhn.fhir.batch2.api.IJobPersistence;
import ca.uhn.fhir.batch2.api.JobExecutionFailedException;
import ca.uhn.fhir.batch2.coordinator.BaseDataSink;
import ca.uhn.fhir.batch2.coordinator.JobDefinitionRegistry;
import ca.uhn.fhir.batch2.maintenance.JobChunkProgressAccumulator;
import ca.uhn.fhir.batch2.model.JobWorkCursor;
import ca.uhn.fhir.batch2.model.StatusEnum;
import ca.uhn.fhir.batch2.model.WorkChunkData;
import ca.uhn.fhir.batch2.progress.InstanceProgress;
import ca.uhn.fhir.batch2.progress.JobInstanceProgressCalculator;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.util.JsonUtil;
import ca.uhn.fhir.util.Logs;
import java.util.Date;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public class ReductionStepDataSink<PT extends IModelJson, IT extends IModelJson, OT extends IModelJson>
extends BaseDataSink<PT, IT, OT> {
    private static final Logger ourLog = Logs.getBatchTroubleshootingLog();
    private final IJobPersistence myJobPersistence;
    private final JobDefinitionRegistry myJobDefinitionRegistry;

    public ReductionStepDataSink(String theInstanceId, JobWorkCursor<PT, IT, OT> theJobWorkCursor, IJobPersistence thePersistence, JobDefinitionRegistry theJobDefinitionRegistry) {
        super(theInstanceId, theJobWorkCursor);
        this.myJobPersistence = thePersistence;
        this.myJobDefinitionRegistry = theJobDefinitionRegistry;
    }

    @Override
    public void accept(WorkChunkData<OT> theData) {
        String instanceId = this.getInstanceId();
        OT data = theData.getData();
        String dataString = JsonUtil.serialize(data, (boolean)false);
        JobChunkProgressAccumulator progressAccumulator = new JobChunkProgressAccumulator();
        JobInstanceProgressCalculator myJobInstanceProgressCalculator = new JobInstanceProgressCalculator(this.myJobPersistence, progressAccumulator, this.myJobDefinitionRegistry);
        InstanceProgress progress = myJobInstanceProgressCalculator.calculateInstanceProgress(instanceId);
        boolean changed = this.myJobPersistence.updateInstance(instanceId, instance -> {
            Validate.validState((boolean)StatusEnum.FINALIZE.equals((Object)instance.getStatus()), (String)"Job %s must be in FINALIZE state.  In %s", (Object[])new Object[]{instanceId, instance.getStatus()});
            if (instance.getReport() != null) {
                ourLog.error("Report has already been set. Now it is being overwritten. Last in will win!");
            }
            progress.updateInstanceForReductionStep(instance);
            instance.setReport(dataString);
            instance.setStatus(StatusEnum.COMPLETED);
            instance.setEndTime(new Date());
            ourLog.info("Finalizing job instance {} with report length {} chars", (Object)instance.getInstanceId(), (Object)dataString.length());
            if (ourLog.isTraceEnabled()) {
                ourLog.trace("New instance state: {}", (Object)JsonUtil.serialize((Object)instance));
            }
            return true;
        });
        if (!changed) {
            ourLog.error("No instance found with Id {} in FINALIZE state", (Object)instanceId);
            throw new JobExecutionFailedException(Msg.code((int)2097) + "No instance found with Id " + instanceId);
        }
    }

    @Override
    public int getWorkChunkCount() {
        return 0;
    }
}

