/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.step;

import ca.uhn.fhir.batch2.jobs.chunk.PartitionedUrlChunkRangeJson;
import ca.uhn.fhir.batch2.jobs.parameters.PartitionedUrl;
import ca.uhn.fhir.batch2.jobs.step.IIdChunkProducer;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.pid.IResourcePidStream;
import ca.uhn.fhir.jpa.api.svc.IBatch2DaoSvc;
import ca.uhn.fhir.util.Logs;
import jakarta.annotation.Nullable;
import java.util.Date;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;

public class PartitionedUrlListIdChunkProducer
implements IIdChunkProducer<PartitionedUrlChunkRangeJson> {
    private static final Logger ourLog = Logs.getBatchTroubleshootingLog();
    private final IBatch2DaoSvc myBatch2DaoSvc;

    public PartitionedUrlListIdChunkProducer(IBatch2DaoSvc theBatch2DaoSvc) {
        this.myBatch2DaoSvc = theBatch2DaoSvc;
    }

    @Override
    public IResourcePidStream fetchResourceIdStream(Date theStart, Date theEnd, @Nullable RequestPartitionId theRequestPartitionId, PartitionedUrlChunkRangeJson theData) {
        RequestPartitionId targetPartitionId;
        String theUrl;
        PartitionedUrl partitionedUrl = theData.getPartitionedUrl();
        if (partitionedUrl == null) {
            theUrl = null;
            targetPartitionId = theRequestPartitionId;
            ourLog.info("Fetching resource ID chunk for everything - Range {} - {}", (Object)theStart, (Object)theEnd);
        } else {
            theUrl = partitionedUrl.getUrl();
            targetPartitionId = (RequestPartitionId)ObjectUtils.defaultIfNull((Object)partitionedUrl.getRequestPartitionId(), (Object)theRequestPartitionId);
            ourLog.info("Fetching resource ID chunk for URL {} - Range {} - {}", new Object[]{partitionedUrl.getUrl(), theStart, theEnd});
        }
        return this.myBatch2DaoSvc.fetchResourceIdStream(theStart, theEnd, targetPartitionId, theUrl);
    }
}

