/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.model;

import ca.uhn.fhir.batch2.api.IJobCompletionHandler;
import ca.uhn.fhir.batch2.api.IJobParametersValidator;
import ca.uhn.fhir.batch2.api.IJobStepWorker;
import ca.uhn.fhir.batch2.api.IReductionStepWorker;
import ca.uhn.fhir.batch2.api.VoidModel;
import ca.uhn.fhir.batch2.model.JobDefinitionReductionStep;
import ca.uhn.fhir.batch2.model.JobDefinitionStep;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.util.Logs;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public class JobDefinition<PT extends IModelJson> {
    private static final Logger ourLog = Logs.getBatchTroubleshootingLog();
    public static final int ID_MAX_LENGTH = 100;
    private final String myJobDefinitionId;
    private final int myJobDefinitionVersion;
    private final Class<PT> myParametersType;
    private final List<JobDefinitionStep<PT, ?, ?>> mySteps;
    private final String myJobDescription;
    private final IJobParametersValidator<PT> myParametersValidator;
    private final boolean myGatedExecution;
    private final List<String> myStepIds;
    private final IJobCompletionHandler<PT> myCompletionHandler;
    private final IJobCompletionHandler<PT> myErrorHandler;

    private JobDefinition(String theJobDefinitionId, int theJobDefinitionVersion, String theJobDescription, Class<PT> theParametersType, List<JobDefinitionStep<PT, ?, ?>> theSteps, IJobParametersValidator<PT> theParametersValidator, boolean theGatedExecution, IJobCompletionHandler<PT> theCompletionHandler, IJobCompletionHandler<PT> theErrorHandler) {
        Validate.isTrue((theJobDefinitionId.length() <= 100 ? 1 : 0) != 0, (String)"Maximum ID length is %d", (long)100L);
        Validate.notBlank((CharSequence)theJobDefinitionId, (String)"No job definition ID supplied", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)theJobDescription, (String)"No job description supplied", (Object[])new Object[0]);
        Validate.isTrue((theJobDefinitionVersion >= 1 ? 1 : 0) != 0, (String)"No job definition version supplied (must be >= 1)", (Object[])new Object[0]);
        Validate.isTrue((theSteps.size() >= 2 ? 1 : 0) != 0, (String)"At least 2 steps must be supplied", (Object[])new Object[0]);
        this.myJobDefinitionId = theJobDefinitionId;
        this.myJobDefinitionVersion = theJobDefinitionVersion;
        this.myJobDescription = theJobDescription;
        this.mySteps = theSteps;
        this.myStepIds = this.mySteps.stream().map(JobDefinitionStep::getStepId).collect(Collectors.toList());
        this.myParametersType = theParametersType;
        this.myParametersValidator = theParametersValidator;
        this.myGatedExecution = theGatedExecution;
        this.myCompletionHandler = theCompletionHandler;
        this.myErrorHandler = theErrorHandler;
    }

    @Nullable
    public IJobCompletionHandler<PT> getCompletionHandler() {
        return this.myCompletionHandler;
    }

    @Nullable
    public IJobCompletionHandler<PT> getErrorHandler() {
        return this.myErrorHandler;
    }

    @Nullable
    public IJobParametersValidator<PT> getParametersValidator() {
        return this.myParametersValidator;
    }

    public String getJobDescription() {
        return this.myJobDescription;
    }

    public String getJobDefinitionId() {
        return this.myJobDefinitionId;
    }

    public int getJobDefinitionVersion() {
        return this.myJobDefinitionVersion;
    }

    public Class<PT> getParametersType() {
        return this.myParametersType;
    }

    public List<JobDefinitionStep<PT, ?, ?>> getSteps() {
        return this.mySteps;
    }

    public String getFirstStepId() {
        JobDefinitionStep<PT, ?, ?> firstStep = this.mySteps.get(0);
        return firstStep.getStepId();
    }

    public boolean isGatedExecution() {
        return this.myGatedExecution;
    }

    public boolean isLastStepReduction() {
        int stepCount = this.getSteps().size();
        return stepCount >= 1 && this.getSteps().get(stepCount - 1).isReductionStep();
    }

    public int getStepIndex(String theStepId) {
        int retVal = this.myStepIds.indexOf(theStepId);
        Validate.isTrue((retVal != -1 ? 1 : 0) != 0);
        return retVal;
    }

    public static Builder<IModelJson, VoidModel> newBuilder() {
        return new Builder<IModelJson, VoidModel>();
    }

    public static class Builder<PT extends IModelJson, NIT extends IModelJson> {
        private final List<JobDefinitionStep<PT, ?, ?>> mySteps;
        private String myJobDefinitionId;
        private int myJobDefinitionVersion;
        private String myJobDescription;
        private Class<PT> myJobParametersType;
        private Class<NIT> myNextInputType;
        @Nullable
        private IJobParametersValidator<PT> myParametersValidator;
        private boolean myGatedExecution;
        private IJobCompletionHandler<PT> myCompletionHandler;
        private IJobCompletionHandler<PT> myErrorHandler;

        Builder() {
            this.mySteps = new ArrayList();
        }

        Builder(List<JobDefinitionStep<PT, ?, ?>> theSteps, String theJobDefinitionId, int theJobDefinitionVersion, String theJobDescription, Class<PT> theJobParametersType, Class<NIT> theNextInputType, @Nullable IJobParametersValidator<PT> theParametersValidator, boolean theGatedExecution, IJobCompletionHandler<PT> theCompletionHandler, IJobCompletionHandler<PT> theErrorHandler) {
            this.mySteps = theSteps;
            this.myJobDefinitionId = theJobDefinitionId;
            this.myJobDefinitionVersion = theJobDefinitionVersion;
            this.myJobDescription = theJobDescription;
            this.myJobParametersType = theJobParametersType;
            this.myNextInputType = theNextInputType;
            this.myParametersValidator = theParametersValidator;
            this.myGatedExecution = theGatedExecution;
            this.myCompletionHandler = theCompletionHandler;
            this.myErrorHandler = theErrorHandler;
        }

        public Builder<PT, NIT> setJobDefinitionId(String theJobDefinitionId) {
            this.myJobDefinitionId = theJobDefinitionId;
            return this;
        }

        public Builder<PT, NIT> setJobDefinitionVersion(int theJobDefinitionVersion) {
            Validate.isTrue((theJobDefinitionVersion > 0 ? 1 : 0) != 0, (String)"theJobDefinitionVersion must be > 0", (Object[])new Object[0]);
            this.myJobDefinitionVersion = theJobDefinitionVersion;
            return this;
        }

        public <OT extends IModelJson> Builder<PT, OT> addFirstStep(String theStepId, String theStepDescription, Class<OT> theOutputType, IJobStepWorker<PT, VoidModel, OT> theStepWorker) {
            this.mySteps.add(new JobDefinitionStep<PT, VoidModel, OT>(theStepId, theStepDescription, theStepWorker, VoidModel.class, theOutputType));
            return new Builder<PT, OT>(this.mySteps, this.myJobDefinitionId, this.myJobDefinitionVersion, this.myJobDescription, this.myJobParametersType, theOutputType, this.myParametersValidator, this.myGatedExecution, this.myCompletionHandler, this.myErrorHandler);
        }

        public <OT extends IModelJson> Builder<PT, OT> addIntermediateStep(String theStepId, String theStepDescription, Class<OT> theOutputType, IJobStepWorker<PT, NIT, OT> theStepWorker) {
            this.mySteps.add(new JobDefinitionStep<PT, NIT, OT>(theStepId, theStepDescription, theStepWorker, this.myNextInputType, theOutputType));
            return new Builder<PT, OT>(this.mySteps, this.myJobDefinitionId, this.myJobDefinitionVersion, this.myJobDescription, this.myJobParametersType, theOutputType, this.myParametersValidator, this.myGatedExecution, this.myCompletionHandler, this.myErrorHandler);
        }

        public Builder<PT, VoidModel> addLastStep(String theStepId, String theStepDescription, IJobStepWorker<PT, NIT, VoidModel> theStepWorker) {
            this.mySteps.add(new JobDefinitionStep<PT, NIT, VoidModel>(theStepId, theStepDescription, theStepWorker, this.myNextInputType, VoidModel.class));
            return new Builder<PT, VoidModel>(this.mySteps, this.myJobDefinitionId, this.myJobDefinitionVersion, this.myJobDescription, this.myJobParametersType, VoidModel.class, this.myParametersValidator, this.myGatedExecution, this.myCompletionHandler, this.myErrorHandler);
        }

        public <OT extends IModelJson> Builder<PT, OT> addFinalReducerStep(String theStepId, String theStepDescription, Class<OT> theOutputType, IReductionStepWorker<PT, NIT, OT> theStepWorker) {
            if (!this.myGatedExecution) {
                throw new ConfigurationException(Msg.code((int)2106) + String.format("Job Definition %s has a reducer step but is not gated", this.myJobDefinitionId));
            }
            this.mySteps.add(new JobDefinitionReductionStep<PT, NIT, OT>(theStepId, theStepDescription, theStepWorker, this.myNextInputType, theOutputType));
            return new Builder<PT, OT>(this.mySteps, this.myJobDefinitionId, this.myJobDefinitionVersion, this.myJobDescription, this.myJobParametersType, theOutputType, this.myParametersValidator, this.myGatedExecution, this.myCompletionHandler, this.myErrorHandler);
        }

        public JobDefinition<PT> build() {
            Validate.notNull(this.myJobParametersType, (String)"No job parameters type was supplied", (Object[])new Object[0]);
            return new JobDefinition<PT>(this.myJobDefinitionId, this.myJobDefinitionVersion, this.myJobDescription, this.myJobParametersType, Collections.unmodifiableList(this.mySteps), this.myParametersValidator, this.myGatedExecution, this.myCompletionHandler, this.myErrorHandler);
        }

        public Builder<PT, NIT> setJobDescription(String theJobDescription) {
            this.myJobDescription = theJobDescription;
            return this;
        }

        public <NPT extends IModelJson> Builder<NPT, NIT> setParametersType(@Nonnull Class<NPT> theJobParametersType) {
            Validate.notNull(theJobParametersType, (String)"theJobParametersType must not be null", (Object[])new Object[0]);
            Validate.isTrue((this.myJobParametersType == null ? 1 : 0) != 0, (String)"Can not supply multiple parameters types, already have: %s", (Object[])new Object[]{this.myJobParametersType});
            this.myJobParametersType = theJobParametersType;
            return this;
        }

        public Builder<PT, NIT> setParametersValidator(@Nonnull IJobParametersValidator<PT> theParametersValidator) {
            Validate.notNull(theParametersValidator, (String)"theParametersValidator must not be null", (Object[])new Object[0]);
            Validate.isTrue((this.myParametersValidator == null ? 1 : 0) != 0, (String)"Can not supply multiple parameters validators. Already have: %s", (Object[])new Object[]{this.myParametersValidator});
            this.myParametersValidator = theParametersValidator;
            return this;
        }

        public Builder<PT, NIT> gatedExecution() {
            this.myGatedExecution = true;
            return this;
        }

        public Builder<PT, NIT> completionHandler(IJobCompletionHandler<PT> theCompletionHandler) {
            Validate.isTrue((this.myCompletionHandler == null ? 1 : 0) != 0, (String)"Can not supply multiple completion handlers", (Object[])new Object[0]);
            this.myCompletionHandler = theCompletionHandler;
            return this;
        }

        public Builder<PT, NIT> errorHandler(IJobCompletionHandler<PT> theErrorHandler) {
            Validate.isTrue((this.myErrorHandler == null ? 1 : 0) != 0, (String)"Can not supply multiple error handlers", (Object[])new Object[0]);
            this.myErrorHandler = theErrorHandler;
            return this;
        }
    }
}

