/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.model;

import ca.uhn.fhir.batch2.api.IJobStepWorker;
import ca.uhn.fhir.model.api.IModelJson;
import jakarta.annotation.Nonnull;
import org.apache.commons.lang3.Validate;

public class JobDefinitionStep<PT extends IModelJson, IT extends IModelJson, OT extends IModelJson> {
    private final String myStepId;
    private final String myStepDescription;
    protected final IJobStepWorker<PT, IT, OT> myJobStepWorker;
    private final Class<IT> myInputType;
    private final Class<OT> myOutputType;

    public JobDefinitionStep(@Nonnull String theStepId, @Nonnull String theStepDescription, @Nonnull IJobStepWorker<PT, IT, OT> theJobStepWorker, @Nonnull Class<IT> theInputType, @Nonnull Class<OT> theOutputType) {
        Validate.notBlank((CharSequence)theStepId, (String)"No step ID specified", (Object[])new Object[0]);
        Validate.isTrue((theStepId.length() <= 100 ? 1 : 0) != 0, (String)"Maximum ID length is %d", (long)100L);
        Validate.notBlank((CharSequence)theStepDescription);
        Validate.notNull(theInputType);
        this.myStepId = theStepId;
        this.myStepDescription = theStepDescription;
        this.myJobStepWorker = theJobStepWorker;
        this.myInputType = theInputType;
        this.myOutputType = theOutputType;
    }

    public String getStepId() {
        return this.myStepId;
    }

    public String getStepDescription() {
        return this.myStepDescription;
    }

    public IJobStepWorker<PT, IT, OT> getJobStepWorker() {
        return this.myJobStepWorker;
    }

    public Class<IT> getInputType() {
        return this.myInputType;
    }

    public Class<OT> getOutputType() {
        return this.myOutputType;
    }

    public boolean isReductionStep() {
        return false;
    }
}

