/*-
 * #%L
 * HAPI FHIR - Clinical Reasoning
 * %%
 * Copyright (C) 2014 - 2024 Smile CDR, Inc.
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package ca.uhn.fhir.cr.common;

import ca.uhn.fhir.context.FhirVersionEnum;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class CanonicalHelper {
	public static <C extends IPrimitiveType<String>> C getCanonicalType(
			FhirVersionEnum fhirVersion, String theCanonical, String theUrl, String theVersion) {
		String url = theVersion == null ? theUrl : String.format("%s|%s", theUrl, theVersion);
		String canonical = theCanonical == null ? url : theCanonical;
		return newCanonicalType(fhirVersion, canonical);
	}

	@SuppressWarnings("unchecked")
	private static <C extends IPrimitiveType<String>> C newCanonicalType(
			FhirVersionEnum fhirVersion, String theCanonical) {
		if (theCanonical == null) {
			return null;
		}
		switch (fhirVersion) {
			case DSTU3:
				return (C) new org.hl7.fhir.dstu3.model.StringType(theCanonical);
			case R4:
				return (C) new org.hl7.fhir.r4.model.CanonicalType(theCanonical);
			case R5:
				return (C) new org.hl7.fhir.r5.model.CanonicalType(theCanonical);
			default:
				return null;
		}
	}
}
