/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.batch2;

import ca.uhn.fhir.batch2.api.IFirstJobStepWorker;
import ca.uhn.fhir.batch2.api.IJobDataSink;
import ca.uhn.fhir.batch2.api.JobExecutionFailedException;
import ca.uhn.fhir.batch2.api.RunOutcome;
import ca.uhn.fhir.batch2.api.StepExecutionDetails;
import ca.uhn.fhir.batch2.api.VoidModel;
import ca.uhn.fhir.batch2.jobs.chunk.ChunkRangeJson;
import ca.uhn.fhir.batch2.util.Batch2Utils;
import ca.uhn.fhir.mdm.batch2.clear.MdmClearJobParameters;
import ca.uhn.fhir.model.api.IModelJson;
import jakarta.annotation.Nonnull;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MdmGenerateRangeChunksStep
implements IFirstJobStepWorker<MdmClearJobParameters, ChunkRangeJson> {
    private static final Logger ourLog = LoggerFactory.getLogger(MdmGenerateRangeChunksStep.class);

    @Nonnull
    public RunOutcome run(@Nonnull StepExecutionDetails<MdmClearJobParameters, VoidModel> theStepExecutionDetails, @Nonnull IJobDataSink<ChunkRangeJson> theDataSink) throws JobExecutionFailedException {
        MdmClearJobParameters params = (MdmClearJobParameters)theStepExecutionDetails.getParameters();
        Date start = Batch2Utils.BATCH_START_DATE;
        Date end = new Date();
        for (String nextResourceType : params.getResourceNames()) {
            ourLog.info("Initiating mdm clear of [{}]] Golden Resources from {} to {}", new Object[]{nextResourceType, start, end});
            assert (nextResourceType != null);
            ChunkRangeJson nextRange = new ChunkRangeJson(start, end).setResourceType(nextResourceType).setPartitionId(params.getRequestPartitionId());
            theDataSink.accept((IModelJson)nextRange);
        }
        return RunOutcome.SUCCESS;
    }
}

