/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.batch2.clear;

import ca.uhn.fhir.batch2.api.IJobParametersValidator;
import ca.uhn.fhir.batch2.api.IJobStepWorker;
import ca.uhn.fhir.batch2.jobs.chunk.ChunkRangeJson;
import ca.uhn.fhir.batch2.jobs.chunk.ResourceIdListWorkChunkJson;
import ca.uhn.fhir.batch2.model.JobDefinition;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.svc.IGoldenResourceSearchSvc;
import ca.uhn.fhir.mdm.api.IMdmSettings;
import ca.uhn.fhir.mdm.batch2.LoadGoldenIdsStep;
import ca.uhn.fhir.mdm.batch2.MdmGenerateRangeChunksStep;
import ca.uhn.fhir.mdm.batch2.clear.MdmClearJobParameters;
import ca.uhn.fhir.mdm.batch2.clear.MdmClearJobParametersValidator;
import ca.uhn.fhir.mdm.batch2.clear.MdmClearStep;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MdmClearAppCtx {
    public static final String JOB_MDM_CLEAR = "MDM_CLEAR";
    public static final String MDM_CLEAR_JOB_BEAN_NAME = "mdmClearJobDefinition";

    @Bean(name={"mdmClearJobDefinition"})
    public JobDefinition<MdmClearJobParameters> mdmClearJobDefinition(DaoRegistry theDaoRegistry, IGoldenResourceSearchSvc theGoldenResourceSearchSvc, IMdmSettings theMdmSettings) {
        return JobDefinition.newBuilder().setJobDefinitionId(JOB_MDM_CLEAR).setJobDescription("Clear mdm links and golden resrouces").setJobDefinitionVersion(1).setParametersType(MdmClearJobParameters.class).setParametersValidator((IJobParametersValidator)this.MdmJobParametersValidator(theDaoRegistry, theMdmSettings)).gatedExecution().addFirstStep("generate-ranges", "Generate date ranges to Mdm Clear", ChunkRangeJson.class, (IJobStepWorker)this.mdmGenerateRangeChunksStep()).addIntermediateStep("find-golden-resource-ids", "Load ids of golden resources to be cleared", ResourceIdListWorkChunkJson.class, (IJobStepWorker)this.loadGoldenIdsStep(theGoldenResourceSearchSvc)).addLastStep("remove-golden-resources-and-links", "Remove golden resources and mdm links", (IJobStepWorker)this.mdmClearStep()).build();
    }

    @Bean
    public MdmClearJobParametersValidator MdmJobParametersValidator(DaoRegistry theDaoRegistry, IMdmSettings theMdmSettings) {
        return new MdmClearJobParametersValidator(theDaoRegistry, theMdmSettings);
    }

    @Bean
    public MdmClearStep mdmClearStep() {
        return new MdmClearStep();
    }

    @Bean
    public MdmGenerateRangeChunksStep mdmGenerateRangeChunksStep() {
        return new MdmGenerateRangeChunksStep();
    }

    @Bean
    public LoadGoldenIdsStep loadGoldenIdsStep(IGoldenResourceSearchSvc theGoldenResourceSearchSvc) {
        return new LoadGoldenIdsStep(theGoldenResourceSearchSvc);
    }
}

