/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.batch2.clear;

import ca.uhn.fhir.batch2.jobs.parameters.PartitionedUrlJobParameters;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.Pattern;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class MdmClearJobParameters
extends PartitionedUrlJobParameters {
    @JsonProperty(value="resourceType")
    @Nonnull
    private List<@Pattern(regexp="^[A-Z][A-Za-z]+$", message="If populated, must be a valid resource type'") String> myResourceNames;

    public List<String> getResourceNames() {
        if (this.myResourceNames == null) {
            this.myResourceNames = new ArrayList<String>();
        }
        return this.myResourceNames;
    }

    public MdmClearJobParameters addResourceType(@Nonnull String theResourceName) {
        Validate.notNull((Object)theResourceName);
        this.getResourceNames().add(theResourceName);
        return this;
    }

    public void setResourceNames(@Nonnull List<String> theResourceNames) {
        this.myResourceNames = theResourceNames;
    }
}

