/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.batch2.clear;

import ca.uhn.fhir.batch2.api.IJobDataSink;
import ca.uhn.fhir.batch2.api.IJobStepWorker;
import ca.uhn.fhir.batch2.api.JobExecutionFailedException;
import ca.uhn.fhir.batch2.api.RunOutcome;
import ca.uhn.fhir.batch2.api.StepExecutionDetails;
import ca.uhn.fhir.batch2.api.VoidModel;
import ca.uhn.fhir.batch2.jobs.chunk.ResourceIdListWorkChunkJson;
import ca.uhn.fhir.jpa.api.svc.IDeleteExpungeSvc;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.api.svc.IMdmClearHelperSvc;
import ca.uhn.fhir.jpa.dao.tx.HapiTransactionService;
import ca.uhn.fhir.mdm.batch2.clear.MdmClearJobParameters;
import ca.uhn.fhir.mdm.dao.IMdmLinkDao;
import ca.uhn.fhir.mdm.interceptor.MdmStorageInterceptor;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.util.StopWatch;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

public class MdmClearStep
implements IJobStepWorker<MdmClearJobParameters, ResourceIdListWorkChunkJson, VoidModel> {
    private static final Logger ourLog = LoggerFactory.getLogger(MdmClearStep.class);
    private static Runnable ourClearCompletionCallbackForUnitTest;
    @Autowired
    HapiTransactionService myHapiTransactionService;
    @Autowired
    IIdHelperService myIdHelperService;
    @Autowired
    IMdmLinkDao myMdmLinkSvc;
    @Autowired
    private IMdmClearHelperSvc<? extends IResourcePersistentId<?>> myIMdmClearHelperSvc;

    @Nonnull
    public RunOutcome run(@Nonnull StepExecutionDetails<MdmClearJobParameters, ResourceIdListWorkChunkJson> theStepExecutionDetails, @Nonnull IJobDataSink<VoidModel> theDataSink) throws JobExecutionFailedException {
        SystemRequestDetails requestDetails = new SystemRequestDetails();
        requestDetails.setRetry(true);
        requestDetails.setMaxRetries(100);
        requestDetails.setRequestPartitionId(((ResourceIdListWorkChunkJson)theStepExecutionDetails.getData()).getRequestPartitionId());
        TransactionDetails transactionDetails = new TransactionDetails();
        this.myHapiTransactionService.execute((RequestDetails)requestDetails, transactionDetails, (TransactionCallback)this.buildJob((RequestDetails)requestDetails, transactionDetails, theStepExecutionDetails));
        return new RunOutcome(((ResourceIdListWorkChunkJson)theStepExecutionDetails.getData()).size());
    }

    MdmClearJob buildJob(RequestDetails requestDetails, TransactionDetails transactionDetails, StepExecutionDetails<MdmClearJobParameters, ResourceIdListWorkChunkJson> theStepExecutionDetails) {
        return new MdmClearJob(requestDetails, transactionDetails, theStepExecutionDetails);
    }

    @VisibleForTesting
    public static void setClearCompletionCallbackForUnitTest(Runnable theClearCompletionCallbackForUnitTest) {
        ourClearCompletionCallbackForUnitTest = theClearCompletionCallbackForUnitTest;
    }

    class MdmClearJob
    implements TransactionCallback<Void> {
        private final RequestDetails myRequestDetails;
        private final TransactionDetails myTransactionDetails;
        private final ResourceIdListWorkChunkJson myData;
        private final String myChunkId;
        private final String myInstanceId;

        public MdmClearJob(RequestDetails theRequestDetails, TransactionDetails theTransactionDetails, StepExecutionDetails<MdmClearJobParameters, ResourceIdListWorkChunkJson> theStepExecutionDetails) {
            this.myRequestDetails = theRequestDetails;
            this.myTransactionDetails = theTransactionDetails;
            this.myData = (ResourceIdListWorkChunkJson)theStepExecutionDetails.getData();
            this.myInstanceId = theStepExecutionDetails.getInstance().getInstanceId();
            this.myChunkId = theStepExecutionDetails.getChunkId();
        }

        public Void doInTransaction(@Nonnull TransactionStatus theStatus) {
            List persistentIds = this.myData.getResourcePersistentIds(MdmClearStep.this.myIdHelperService);
            if (persistentIds.isEmpty()) {
                return null;
            }
            MdmStorageInterceptor.setLinksDeletedBeforehand();
            try {
                this.performWork(persistentIds);
            }
            finally {
                MdmStorageInterceptor.resetLinksDeletedBeforehand();
            }
            return null;
        }

        private void performWork(List<? extends IResourcePersistentId> thePersistentIds) {
            ourLog.info("Starting mdm clear work chunk with {} resources - Instance[{}] Chunk[{}]", new Object[]{thePersistentIds.size(), this.myInstanceId, this.myChunkId});
            StopWatch sw = new StopWatch();
            MdmClearStep.this.myMdmLinkSvc.deleteLinksWithAnyReferenceToPids(thePersistentIds);
            ourLog.trace("Deleted {} mdm links in {}", (Object)thePersistentIds.size(), (Object)StopWatch.formatMillis((long)sw.getMillis()));
            IDeleteExpungeSvc deleteExpungeSvc = MdmClearStep.this.myIMdmClearHelperSvc.getDeleteExpungeSvc();
            int deletedRecords = deleteExpungeSvc.deleteExpunge(thePersistentIds, false, null);
            ourLog.trace("Deleted {} of {} golden resources in {}", new Object[]{deletedRecords, thePersistentIds.size(), StopWatch.formatMillis((long)sw.getMillis())});
            ourLog.info("Finished removing {} of {} golden resources in {} - {}/sec - Instance[{}] Chunk[{}]", new Object[]{deletedRecords, thePersistentIds.size(), sw, sw.formatThroughput((long)thePersistentIds.size(), TimeUnit.SECONDS), this.myInstanceId, this.myChunkId});
            if (ourClearCompletionCallbackForUnitTest != null) {
                ourClearCompletionCallbackForUnitTest.run();
            }
        }
    }
}

