/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.broker;

import ca.uhn.fhir.broker.api.IMessageListener;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.rest.server.messaging.IMessage;
import ca.uhn.test.concurrency.IPointcutLatch;
import ca.uhn.test.concurrency.PointcutLatch;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.MessagingException;

public class TestMessageListenerWithLatch<M extends IMessage<P>, P>
implements IMessageListener<P>,
IPointcutLatch,
AutoCloseable {
    private static final Logger ourLog = LoggerFactory.getLogger(TestMessageListenerWithLatch.class);
    private final PointcutLatch myMessageHandledLatch;
    private Consumer<IMessage<P>> myCallback;
    private final Class<P> myPayloadType;
    private final List<M> myReceivedMessages = Collections.synchronizedList(new ArrayList());
    private final Class<M> myMessageType;

    public TestMessageListenerWithLatch(Class<M> theMessageType, Class<P> thePayloadType) {
        this(theMessageType, thePayloadType, new PointcutLatch("TestMessageListener for " + thePayloadType.getName()), null);
    }

    public TestMessageListenerWithLatch(Class<M> theMessageType, Class<P> thePayloadType, PointcutLatch theMessageHandledLatch) {
        this(theMessageType, thePayloadType, theMessageHandledLatch, null);
    }

    public TestMessageListenerWithLatch(Class<M> theMessageType, Class<P> thePayloadType, PointcutLatch theMessageHandledLatch, Consumer<IMessage<P>> theCallback) {
        this.myMessageType = theMessageType;
        this.myPayloadType = thePayloadType;
        this.myMessageHandledLatch = theMessageHandledLatch;
        this.myCallback = theCallback;
    }

    public void handleMessage(@Nonnull IMessage<P> theMessage) throws MessagingException {
        if (this.myCallback != null) {
            this.myCallback.accept(theMessage);
        }
        Assertions.assertInstanceOf(this.myMessageType, theMessage);
        IMessage<P> message = theMessage;
        Assertions.assertInstanceOf(this.myPayloadType, (Object)message.getPayload());
        ourLog.debug("Received message {}", message.getPayload());
        this.myReceivedMessages.add(message);
        if (this.myMessageHandledLatch != null) {
            this.myMessageHandledLatch.call(message);
        }
    }

    public Class<P> getPayloadType() {
        return this.myPayloadType;
    }

    public void clear() {
        this.myMessageHandledLatch.clear();
        this.myReceivedMessages.clear();
    }

    public void setExpectedCount(int count) {
        this.myMessageHandledLatch.setExpectedCount(count);
    }

    public List<HookParams> awaitExpected() throws InterruptedException {
        return this.myMessageHandledLatch.awaitExpected();
    }

    public List<M> getReceivedMessages() {
        return this.myReceivedMessages;
    }

    @Override
    public void close() throws Exception {
        this.myMessageHandledLatch.clear();
        this.myReceivedMessages.clear();
    }

    public void setCallback(Consumer<IMessage<P>> theCallback) {
        this.myCallback = theCallback;
    }

    public P getLastReceivedMessagePayload() {
        M lastMessage = this.getLastReceivedMessage();
        return (P)(lastMessage != null ? lastMessage.getPayload() : null);
    }

    public Map<String, Object> getLastReceivedMessageHeaders() {
        M lastMessage = this.getLastReceivedMessage();
        return lastMessage != null ? lastMessage.getHeaders() : null;
    }

    public M getLastReceivedMessage() {
        if (this.myReceivedMessages.isEmpty()) {
            return null;
        }
        return (M)((IMessage)this.myReceivedMessages.get(this.myReceivedMessages.size() - 1));
    }
}

