/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.storage.test;

import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.conformance.DateSearchTestCase;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.test.utilities.ITestDataBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDateSearchDaoTests {
    private static final Logger ourLog = LoggerFactory.getLogger(BaseDateSearchDaoTests.class);
    IIdType myObservationId;
    Fixture myFixture;

    @BeforeEach
    public void setTimeZoneEST() {
        TimeZone.setDefault(TimeZone.getTimeZone("EST"));
    }

    @AfterEach
    public void resetTimeZone() {
        TimeZone.setDefault(null);
    }

    @BeforeEach
    public void setupFixture() {
        this.myFixture = this.constructFixture();
    }

    @AfterEach
    public void cleanup() {
        this.myFixture.cleanup();
    }

    @ParameterizedTest
    @MethodSource(value={"dateSearchCases"})
    public void testDateSearchMatching(String theResourceDate, String theQuery, boolean theExpectedMatch, String theFileName, int theLineNumber) {
        if (this.isShouldSkip(theResourceDate, theQuery)) {
            return;
        }
        this.myObservationId = this.myFixture.createObservationWithEffectiveDate(theResourceDate);
        boolean matched = this.myFixture.isObservationSearchMatch(theQuery, this.myObservationId);
        BaseDateSearchDaoTests.assertExpectedMatch(theResourceDate, theQuery, theExpectedMatch, matched, theFileName, theLineNumber);
    }

    protected boolean isShouldSkip(String theResourceDate, String theQuery) {
        return false;
    }

    protected static void assertExpectedMatch(String theResourceDate, String theQuery, boolean theExpectedMatch, boolean matched, String theFileName, int theLineNumber) {
        String message = "Expected " + theQuery + " to " + (theExpectedMatch ? "" : "not ") + "match " + theResourceDate + " (" + theFileName + ":" + theLineNumber + ")";
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)matched).as(message, new Object[0])).isEqualTo(theExpectedMatch);
    }

    public static List<Arguments> dateSearchCases() {
        return DateSearchTestCase.ourCases.stream().map(DateSearchTestCase::toArguments).collect(Collectors.toList());
    }

    protected abstract Fixture constructFixture();

    public static interface Fixture {
        public IIdType createObservationWithEffectiveDate(String var1);

        public boolean isObservationSearchMatch(String var1, IIdType var2);

        public void cleanup();
    }

    public static class TestDataBuilderFixture<O extends IBaseResource>
    implements Fixture {
        final ITestDataBuilder myTestDataBuilder;
        final IFhirResourceDao<O> myObservationDao;
        final Set<IIdType> myCreatedIds = new HashSet<IIdType>();

        public TestDataBuilderFixture(ITestDataBuilder theTestDataBuilder, IFhirResourceDao<O> theObservationDao) {
            this.myTestDataBuilder = theTestDataBuilder;
            this.myObservationDao = theObservationDao;
        }

        @Override
        public IIdType createObservationWithEffectiveDate(String theResourceDate) {
            IIdType id = this.myTestDataBuilder.createObservation(new ITestDataBuilder.ICreationArgument[]{this.myTestDataBuilder.withEffectiveDate(theResourceDate)});
            this.myCreatedIds.add(id);
            return id;
        }

        @Override
        public boolean isObservationSearchMatch(String theQuery, IIdType theObservationId) {
            SearchParameterMap map = SearchParameterMap.newSynchronous();
            map.add("date", new DateParam(theQuery));
            ourLog.info("Searching for observation {}", (Object)map);
            IBundleProvider results = this.myObservationDao.search(map);
            boolean matched = results.getAllResourceIds().contains(theObservationId.getIdPart());
            return matched;
        }

        @Override
        public void cleanup() {
            this.myCreatedIds.forEach(arg_0 -> this.myObservationDao.delete(arg_0));
            this.myCreatedIds.clear();
        }
    }
}

