/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.storage.test;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.test.utilities.ITestDataBuilder;
import ca.uhn.fhir.util.BundleBuilder;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

public class DaoTestDataBuilder
implements ITestDataBuilder.WithSupport,
ITestDataBuilder.Support,
AfterEachCallback {
    private static final Logger ourLog = LoggerFactory.getLogger(DaoTestDataBuilder.class);
    final FhirContext myFhirCtx;
    final DaoRegistry myDaoRegistry;
    RequestDetails mySrd;
    final SetMultimap<String, IIdType> myIds = HashMultimap.create();

    public DaoTestDataBuilder(FhirContext theFhirCtx, DaoRegistry theDaoRegistry, RequestDetails theSrd) {
        this.myFhirCtx = theFhirCtx;
        this.myDaoRegistry = theDaoRegistry;
        this.mySrd = theSrd;
    }

    public IIdType doCreateResource(IBaseResource theResource) {
        if (ourLog.isDebugEnabled()) {
            ourLog.debug("create resource {}", (Object)this.myFhirCtx.newJsonParser().encodeResourceToString(theResource));
        }
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(theResource.getClass());
        TransactionDetails details = null;
        details = theResource.getMeta() != null && theResource.getMeta().getLastUpdated() != null ? new TransactionDetails(theResource.getMeta().getLastUpdated()) : new TransactionDetails();
        IIdType id = dao.create(theResource, null, true, this.mySrd, details).getId().toUnqualifiedVersionless();
        this.myIds.put((Object)theResource.fhirType(), (Object)id);
        return id;
    }

    public IIdType doUpdateResource(IBaseResource theResource) {
        TransactionDetails details = null;
        details = theResource.getMeta() != null && theResource.getMeta().getLastUpdated() != null ? new TransactionDetails(theResource.getMeta().getLastUpdated()) : new TransactionDetails();
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(theResource.getClass());
        IIdType id = dao.update(theResource, null, true, false, this.mySrd, details).getId().toUnqualifiedVersionless();
        this.myIds.put((Object)theResource.fhirType(), (Object)id);
        return id;
    }

    public ITestDataBuilder.Support getTestDataBuilderSupport() {
        return this;
    }

    public void setRequestId(String theRequestId) {
        this.mySrd.setRequestId(theRequestId);
    }

    public FhirContext getFhirContext() {
        return this.myFhirCtx;
    }

    public void cleanup() {
        ourLog.info("cleanup {}", this.myIds);
        BundleBuilder builder = new BundleBuilder(this.myFhirCtx);
        this.myIds.values().forEach(arg_0 -> ((BundleBuilder)builder).addTransactionDeleteEntry(arg_0));
        IBaseBundle bundle = builder.getBundle();
        ourLog.trace("Deleting in bundle {}", (Object)this.myFhirCtx.newJsonParser().encodeToString((IBase)bundle));
        this.myDaoRegistry.getSystemDao().transaction(this.mySrd, (Object)bundle);
        this.myIds.clear();
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.cleanup();
    }

    @Configuration
    public static class Config {
        @Autowired
        FhirContext myFhirContext;
        @Autowired
        DaoRegistry myDaoRegistry;

        @Bean
        DaoTestDataBuilder testDataBuilder() {
            return new DaoTestDataBuilder(this.myFhirContext, this.myDaoRegistry, (RequestDetails)new SystemRequestDetails());
        }
    }
}

