/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.storage.test;

import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.dao.IFhirSystemDao;
import ca.uhn.fhir.jpa.api.model.DaoMethodOutcome;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.test.utilities.TagTestUtil;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseMetaType;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Meta;
import org.hl7.fhir.r4.model.Patient;
import org.junit.jupiter.api.Assertions;

public class TagTestCasesUtil {
    private IFhirResourceDao<Patient> myPatientDao;
    private IFhirSystemDao<Bundle, Meta> mySystemDao;
    private RequestDetails myRequestDetails;
    private boolean myMetaOperationSupported;

    public TagTestCasesUtil(IFhirResourceDao<Patient> thePatientDao, IFhirSystemDao<Bundle, Meta> theSystemDao, RequestDetails theRequestDetails, boolean theMetaOperationSupported) {
        this.myPatientDao = thePatientDao;
        this.mySystemDao = theSystemDao;
        this.myRequestDetails = theRequestDetails;
        this.myMetaOperationSupported = theMetaOperationSupported;
    }

    public IBaseResource createResourceAndVerifyMeta(Meta theMetaInputOnCreate, Meta theExpectedMetaAfterCreate) {
        DaoMethodOutcome createOutcome = this.createPatient(theMetaInputOnCreate);
        IIdType versionlessPatientId = createOutcome.getResource().getIdElement().toVersionless();
        Patient patient = (Patient)this.myPatientDao.read(versionlessPatientId, this.myRequestDetails);
        this.verifyMeta((IBaseMetaType)theExpectedMetaAfterCreate, (IBaseMetaType)patient.getMeta());
        if (this.myMetaOperationSupported) {
            Meta meta = (Meta)this.myPatientDao.metaGetOperation(Meta.class, versionlessPatientId, this.myRequestDetails);
            this.verifyMeta((IBaseMetaType)theExpectedMetaAfterCreate, (IBaseMetaType)meta);
            meta = (Meta)this.myPatientDao.metaGetOperation(Meta.class, this.myRequestDetails);
            this.verifyMeta((IBaseMetaType)theExpectedMetaAfterCreate, (IBaseMetaType)meta);
            meta = (Meta)this.mySystemDao.metaGetOperation(this.myRequestDetails);
            this.verifyMeta((IBaseMetaType)theExpectedMetaAfterCreate, (IBaseMetaType)meta);
        }
        IdType versionId = new IdType(String.format("%s/_history/1", patient.getIdElement().toVersionless()));
        patient = (Patient)this.myPatientDao.read((IIdType)versionId, this.myRequestDetails);
        this.verifyMeta((IBaseMetaType)theExpectedMetaAfterCreate, (IBaseMetaType)patient.getMeta());
        return patient;
    }

    public IBaseResource updateResourceAndVerifyMeta(Meta theMetaInputOnCreate, Meta theMetaInputOnUpdate, Meta theExpectedMetaAfterUpdate, boolean theExpectNop) {
        DaoMethodOutcome createOutcome = this.createPatient(theMetaInputOnCreate);
        IIdType versionlessPatientId = createOutcome.getId().toVersionless();
        DaoMethodOutcome updateOutcome = this.updatePatient(versionlessPatientId, theMetaInputOnUpdate);
        Assertions.assertEquals((Object)theExpectNop, (Object)updateOutcome.isNop());
        Patient patient = (Patient)this.myPatientDao.read(versionlessPatientId, this.myRequestDetails);
        this.verifyMeta((IBaseMetaType)theExpectedMetaAfterUpdate, (IBaseMetaType)patient.getMeta());
        if (this.myMetaOperationSupported) {
            Meta meta = (Meta)this.myPatientDao.metaGetOperation(Meta.class, versionlessPatientId, this.myRequestDetails);
            this.verifyMeta((IBaseMetaType)theExpectedMetaAfterUpdate, (IBaseMetaType)meta);
        }
        IdType versionId = new IdType(String.format("%s/_history/2", patient.getIdElement().toVersionless()));
        patient = (Patient)this.myPatientDao.read((IIdType)versionId, this.myRequestDetails);
        this.verifyMeta((IBaseMetaType)theExpectedMetaAfterUpdate, (IBaseMetaType)patient.getMeta());
        return patient;
    }

    public IBaseResource updateResourceAndVerifyVersion(IIdType theResourceId, Meta theMetaInputOnUpdate, String theExpectedVersion) {
        this.updatePatient(theResourceId, theMetaInputOnUpdate);
        Patient patient = (Patient)this.myPatientDao.read(theResourceId, this.myRequestDetails);
        Assertions.assertEquals((Object)theExpectedVersion, (Object)patient.getMeta().getVersionId());
        return patient;
    }

    public void updateResourceWithExistingTagsButInDifferentOrderAndExpectVersionToRemainTheSame_NonInlineModes() {
        Meta metaInputOnCreate = TagTestUtil.createMeta((List)TagTestUtil.generateAllCodingPairs(List.of("sys2", "sys1"), List.of("c", "b", "a")), (List)TagTestUtil.generateAllCodingPairs(List.of("sys2", "sys1"), List.of("c", "b", "a")), List.of("c", "b", "a"));
        DaoMethodOutcome createOutcome = this.createPatient(metaInputOnCreate);
        IIdType versionlessPatientId = createOutcome.getId().toVersionless();
        Meta metaInputOnUpdate = TagTestUtil.createMeta((List)TagTestUtil.generateAllCodingPairs(List.of("sys2", "sys1"), List.of("b", "c", "a")), (List)TagTestUtil.generateAllCodingPairs(List.of("sys2", "sys1"), List.of("b", "c", "a")), List.of("b", "c", "a"));
        this.updateResourceAndVerifyVersion(versionlessPatientId, metaInputOnUpdate, "1");
        metaInputOnUpdate = TagTestUtil.createMeta((List)TagTestUtil.generateAllCodingPairs(List.of("sys2", "sys1"), List.of("aa", "bb", "cc")), (List)TagTestUtil.generateAllCodingPairs(List.of("sys2", "sys1"), List.of("aa", "bb", "cc")), List.of("b", "c", "a"));
        this.updateResourceAndVerifyVersion(versionlessPatientId, metaInputOnUpdate, "2");
        metaInputOnUpdate = TagTestUtil.createMeta((List)TagTestUtil.generateAllCodingPairs(List.of("sys2", "sys1"), List.of("c", "bb", "aa", "b", "cc", "c")), (List)TagTestUtil.generateAllCodingPairs(List.of("sys2", "sys1"), List.of("c", "bb", "aa", "b", "cc", "c")), List.of("b", "c", "a"));
        this.updateResourceAndVerifyVersion(versionlessPatientId, metaInputOnUpdate, "2");
        metaInputOnUpdate = TagTestUtil.createMeta((List)TagTestUtil.generateAllCodingPairs(List.of("sys2"), List.of("bb", "c", "a")), (List)TagTestUtil.generateAllCodingPairs(List.of("sys2"), List.of("bb", "c", "a")), List.of("b", "c", "a"));
        this.updateResourceAndVerifyVersion(versionlessPatientId, metaInputOnUpdate, "2");
    }

    public void updateResourceWithExistingTagsButInDifferentOrderAndExpectVersionToRemainTheSame_InlineMode() {
        Meta metaInputOnCreate = TagTestUtil.createMeta((List)TagTestUtil.generateAllCodingPairs(List.of("sys2", "sys1"), List.of("c", "b", "a")), (List)TagTestUtil.generateAllCodingPairs(List.of("sys2", "sys1"), List.of("c", "b", "a")), List.of("c", "b", "a"));
        DaoMethodOutcome createOutcome = this.createPatient(metaInputOnCreate);
        IIdType versionlessPatientId = createOutcome.getId().toVersionless();
        Meta metaInputOnUpdate = TagTestUtil.createMeta((List)TagTestUtil.generateAllCodingPairs(List.of("sys2", "sys1"), List.of("b", "c", "a")), (List)TagTestUtil.generateAllCodingPairs(List.of("sys2", "sys1"), List.of("b", "c", "a")), List.of("b", "c", "a"));
        this.updateResourceAndVerifyVersion(versionlessPatientId, metaInputOnUpdate, "1");
    }

    public void createResourceWithTagsAndExpectToRetrieveThemSorted() {
        Meta metaInputOnCreate = TagTestUtil.createMeta((List)TagTestUtil.generateAllCodingPairs(List.of("sys2", "sys1"), List.of("c", "b", "a")), (List)TagTestUtil.generateAllCodingPairs(List.of("sys2", "sys1"), List.of("c", "b", "a")), List.of("c", "b", "a"));
        Meta expectedMetaAfterCreate = TagTestUtil.createMeta((List)TagTestUtil.generateAllCodingPairs(List.of("sys1", "sys2"), List.of("a", "b", "c")), (List)TagTestUtil.generateAllCodingPairs(List.of("sys1", "sys2"), List.of("a", "b", "c")), List.of("a", "b", "c"));
        this.createResourceAndVerifyMeta(metaInputOnCreate, expectedMetaAfterCreate);
    }

    public void updateResourceWithTagsAndExpectToRetrieveTagsSorted_NonInlineModes() {
        Meta metaInputOnCreate = TagTestUtil.createMeta((List)TagTestUtil.generateAllCodingPairs(List.of("sys2", "sys1"), List.of("c", "b", "a")), (List)TagTestUtil.generateAllCodingPairs(List.of("sys2", "sys1"), List.of("c", "b", "a")), List.of("c", "b", "a"));
        Meta metaInputOnUpdate = TagTestUtil.createMeta((List)TagTestUtil.generateAllCodingPairs(List.of("sys2", "sys1"), List.of("cc", "bb", "aa")), (List)TagTestUtil.generateAllCodingPairs(List.of("sys2", "sys1"), List.of("cc", "bb", "aa")), List.of("cc", "bb", "aa"));
        Meta expectedMetaAfterUpdate = TagTestUtil.createMeta((List)TagTestUtil.generateAllCodingPairs(List.of("sys1", "sys2"), List.of("a", "aa", "b", "bb", "c", "cc")), (List)TagTestUtil.generateAllCodingPairs(List.of("sys1", "sys2"), List.of("a", "aa", "b", "bb", "c", "cc")), List.of("aa", "bb", "cc"));
        IBaseResource resource = this.updateResourceAndVerifyMeta(metaInputOnCreate, metaInputOnUpdate, expectedMetaAfterUpdate, false);
        Assertions.assertEquals((Object)"2", (Object)resource.getMeta().getVersionId());
        IdType version2Id = new IdType(String.format("%s/_history/2", resource.getIdElement().toVersionless()));
        resource = this.myPatientDao.read((IIdType)version2Id, this.myRequestDetails);
        this.verifyMeta((IBaseMetaType)expectedMetaAfterUpdate, resource.getMeta());
    }

    private DaoMethodOutcome createPatient(Meta theMeta) {
        Patient inputPatient = new Patient();
        inputPatient.setMeta(theMeta);
        return this.myPatientDao.create((IBaseResource)inputPatient, this.myRequestDetails);
    }

    private DaoMethodOutcome updatePatient(IIdType thePatientId, Meta theMeta) {
        Patient inputPatient = new Patient();
        inputPatient.setId(thePatientId);
        inputPatient.setMeta(theMeta);
        return this.myPatientDao.update((IBaseResource)inputPatient, this.myRequestDetails);
    }

    private void verifyMeta(IBaseMetaType theExpectedMeta, IBaseMetaType theActualMeta) {
        TagTestUtil.assertCodingsEqualAndInOrder((List)theExpectedMeta.getTag(), (List)theActualMeta.getTag());
        TagTestUtil.assertCodingsEqualAndInOrder((List)theExpectedMeta.getSecurity(), (List)theActualMeta.getSecurity());
        Assertions.assertEquals((Object)TagTestUtil.toStringList((List)theExpectedMeta.getProfile()), (Object)TagTestUtil.toStringList((List)theActualMeta.getProfile()));
    }

    public void setMetaOperationSupported(boolean theMetaOperationSupported) {
        this.myMetaOperationSupported = theMetaOperationSupported;
    }
}

