/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.api.model;

import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class PersistentIdToForcedIdMap<P extends IResourcePersistentId> {
    private final Map<P, Optional<String>> myResourcePersistentIdOptionalMap;

    public PersistentIdToForcedIdMap(Map<P, Optional<String>> theResourcePersistentIdOptionalMap) {
        this.myResourcePersistentIdOptionalMap = theResourcePersistentIdOptionalMap;
    }

    public Set<String> getResolvedResourceIds() {
        return this.myResourcePersistentIdOptionalMap.entrySet().stream().map(this::getResolvedPid).collect(Collectors.toSet());
    }

    private String getResolvedPid(Map.Entry<P, Optional<String>> entry) {
        return entry.getValue().isPresent() ? entry.getValue().get() : ((IResourcePersistentId)entry.getKey()).toString();
    }

    public Optional<String> get(P theResourcePersistentId) {
        return this.myResourcePersistentIdOptionalMap.get(theResourcePersistentId);
    }

    public Map<P, Optional<String>> getResourcePersistentIdOptionalMap() {
        return this.myResourcePersistentIdOptionalMap;
    }
}

