/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.api.model;

import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.jpa.api.model.TranslationQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;

public class TranslationRequest {
    private CodeableConcept myCodeableConcept = new CodeableConcept();
    private IIdType myResourceId;
    private Boolean myReverse;
    private String myUrl;
    private String myConceptMapVersion;
    private String mySource;
    private String myTarget;
    private String myTargetSystem;

    public TranslationRequest addCode(String theSystem, String theCode) {
        Validate.notBlank((CharSequence)theSystem, (String)"theSystem must not be null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)theCode, (String)"theCode must not be null", (Object[])new Object[0]);
        if (this.getCodeableConcept() == null) {
            this.setCodeableConcept(new CodeableConcept());
        }
        this.getCodeableConcept().addCoding(new Coding().setSystem(theSystem).setCode(theCode));
        return this;
    }

    public CodeableConcept getCodeableConcept() {
        return this.myCodeableConcept;
    }

    public TranslationRequest setCodeableConcept(CodeableConcept theCodeableConcept) {
        this.myCodeableConcept = theCodeableConcept;
        return this;
    }

    public IIdType getResourceId() {
        return this.myResourceId;
    }

    public void setResourceId(IIdType theResourceId) {
        this.myResourceId = theResourceId;
    }

    public Boolean getReverse() {
        return this.myReverse;
    }

    public void setReverse(Boolean theReverse) {
        this.myReverse = theReverse;
    }

    public boolean getReverseAsBoolean() {
        if (this.hasReverse()) {
            return this.myReverse;
        }
        return false;
    }

    public String getUrl() {
        return this.myUrl;
    }

    public TranslationRequest setUrl(String theUrl) {
        this.myUrl = theUrl;
        return this;
    }

    public String getConceptMapVersion() {
        return this.myConceptMapVersion;
    }

    public TranslationRequest setConceptMapVersion(String theConceptMapVersion) {
        this.myConceptMapVersion = theConceptMapVersion;
        return this;
    }

    public String getSource() {
        return this.mySource;
    }

    public TranslationRequest setSource(String theSource) {
        this.mySource = theSource;
        return this;
    }

    public String getTarget() {
        return this.myTarget;
    }

    public TranslationRequest setTarget(String theTarget) {
        this.myTarget = theTarget;
        return this;
    }

    public String getTargetSystem() {
        return this.myTargetSystem;
    }

    public TranslationRequest setTargetSystem(String theTargetSystem) {
        this.myTargetSystem = theTargetSystem;
        return this;
    }

    public List<TranslationQuery> getTranslationQueries() {
        ArrayList<TranslationQuery> retVal = new ArrayList<TranslationQuery>();
        for (Coding coding : this.getCodeableConcept().getCoding()) {
            TranslationQuery translationQuery = new TranslationQuery();
            translationQuery.setCoding(coding);
            if (this.hasResourceId()) {
                translationQuery.setResourceId(this.getResourceId());
            }
            if (this.hasUrl()) {
                translationQuery.setUrl(this.getUrl());
            }
            if (this.hasConceptMapVersion()) {
                translationQuery.setConceptMapVersion(this.getConceptMapVersion());
            }
            if (this.hasSource()) {
                translationQuery.setSource(this.getSource());
            }
            if (this.hasTarget()) {
                translationQuery.setTarget(this.getTarget());
            }
            if (this.hasTargetSystem()) {
                translationQuery.setTargetSystem(this.getTargetSystem());
            }
            retVal.add(translationQuery);
        }
        return retVal;
    }

    public boolean hasResourceId() {
        return this.myResourceId != null;
    }

    public boolean hasReverse() {
        return this.myReverse != null;
    }

    public boolean hasUrl() {
        return StringUtils.isNotBlank((CharSequence)this.myUrl);
    }

    public boolean hasConceptMapVersion() {
        return StringUtils.isNotBlank((CharSequence)this.myConceptMapVersion);
    }

    public boolean hasSource() {
        return StringUtils.isNotBlank((CharSequence)this.mySource);
    }

    public boolean hasTarget() {
        return StringUtils.isNotBlank((CharSequence)this.myTarget);
    }

    public boolean hasTargetSystem() {
        return StringUtils.isNotBlank((CharSequence)this.myTargetSystem);
    }

    public IValidationSupport.TranslateCodeRequest asTranslateCodeRequest() {
        return new IValidationSupport.TranslateCodeRequest(Collections.unmodifiableList(this.getCodeableConcept().getCoding()), this.getTargetSystem(), this.getUrl(), this.getConceptMapVersion(), this.getSource(), this.getTarget(), this.getResourceId(), this.getReverseAsBoolean());
    }

    public static TranslationRequest fromTranslateCodeRequest(IValidationSupport.TranslateCodeRequest theRequest) {
        CodeableConcept sourceCodeableConcept = new CodeableConcept();
        for (IBaseCoding aCoding : theRequest.getCodings()) {
            sourceCodeableConcept.addCoding().setSystem(aCoding.getSystem()).setCode(aCoding.getCode()).setVersion(((Coding)aCoding).getVersion());
        }
        TranslationRequest translationRequest = new TranslationRequest();
        translationRequest.setCodeableConcept(sourceCodeableConcept);
        translationRequest.setConceptMapVersion(theRequest.getConceptMapVersion());
        translationRequest.setUrl(theRequest.getConceptMapUrl());
        translationRequest.setSource(theRequest.getSourceValueSetUrl());
        translationRequest.setTarget(theRequest.getTargetValueSetUrl());
        translationRequest.setTargetSystem(theRequest.getTargetSystemUrl());
        translationRequest.setResourceId(theRequest.getResourceId());
        translationRequest.setReverse(theRequest.isReverse());
        return translationRequest;
    }
}

