/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.api.pid;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.pid.EmptyResourcePidList;
import ca.uhn.fhir.jpa.api.pid.HomogeneousResourcePidList;
import ca.uhn.fhir.jpa.api.pid.IResourcePidList;
import ca.uhn.fhir.jpa.api.pid.MixedResourcePidList;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class ResourcePidListBuilder {
    private static final IResourcePidList EMPTY_CHUNK = new EmptyResourcePidList();

    public static IResourcePidList fromChunksAndDate(List<IResourcePidList> theChunks, Date theEnd) {
        if (theChunks.isEmpty()) {
            return ResourcePidListBuilder.empty();
        }
        LinkedHashSet<IResourcePersistentId> ids = new LinkedHashSet<IResourcePersistentId>();
        RequestPartitionId requestPartitionId = null;
        Date endDate = null;
        HashSet<String> resourceTypes = new HashSet<String>();
        boolean containsMixed = false;
        for (IResourcePidList iResourcePidList : theChunks) {
            Validate.isTrue((requestPartitionId == null || requestPartitionId == iResourcePidList.getRequestPartitionId() ? 1 : 0) != 0);
            requestPartitionId = iResourcePidList.getRequestPartitionId();
            if (iResourcePidList.isEmpty()) continue;
            ids.addAll(iResourcePidList.getIds());
            endDate = ResourcePidListBuilder.getLatestDate(iResourcePidList, endDate, theEnd);
            if (iResourcePidList instanceof MixedResourcePidList) {
                containsMixed = true;
                continue;
            }
            resourceTypes.add(iResourcePidList.getResourceType(0));
        }
        if (containsMixed || resourceTypes.size() > 1) {
            ArrayList<String> types = new ArrayList<String>();
            for (IResourcePidList chunk : theChunks) {
                for (int i = 0; i < chunk.size(); ++i) {
                    types.add(chunk.getResourceType(i));
                }
            }
            return new MixedResourcePidList(types, ids, endDate, requestPartitionId);
        }
        IResourcePidList firstChunk = theChunks.get(0);
        String string = firstChunk.getResourceType(0);
        return new HomogeneousResourcePidList(string, ids, endDate, requestPartitionId);
    }

    private static Date getLatestDate(IResourcePidList theChunk, Date theCurrentEndDate, Date thePassedInEndDate) {
        Date endDate = theCurrentEndDate;
        if (theCurrentEndDate == null) {
            endDate = theChunk.getLastDate();
        } else if (theChunk.getLastDate().after(endDate) && theChunk.getLastDate().before(thePassedInEndDate)) {
            endDate = theChunk.getLastDate();
        }
        return endDate;
    }

    private static IResourcePidList empty() {
        return EMPTY_CHUNK;
    }
}

