/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.api.svc;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.model.PersistentIdToForcedIdMap;
import ca.uhn.fhir.jpa.model.cross.IResourceLookup;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public interface IIdHelperService<T extends IResourcePersistentId> {
    @Nonnull
    public List<T> resolveResourcePersistentIdsWithCache(@Nonnull RequestPartitionId var1, List<IIdType> var2, boolean var3);

    @Nonnull
    public T resolveResourcePersistentIds(@Nonnull RequestPartitionId var1, String var2, String var3);

    @Nonnull
    public T resolveResourcePersistentIds(@Nonnull RequestPartitionId var1, String var2, String var3, boolean var4);

    @Nonnull
    public Map<String, T> resolveResourcePersistentIds(@Nonnull RequestPartitionId var1, String var2, List<String> var3);

    @Nonnull
    public Map<String, T> resolveResourcePersistentIds(@Nonnull RequestPartitionId var1, String var2, List<String> var3, boolean var4);

    @Nonnull
    public IIdType translatePidIdToForcedId(FhirContext var1, String var2, T var3);

    @Nonnull
    public IResourceLookup resolveResourceIdentity(@Nonnull RequestPartitionId var1, String var2, String var3) throws ResourceNotFoundException;

    @Nonnull
    public IResourceLookup resolveResourceIdentity(@Nonnull RequestPartitionId var1, String var2, String var3, boolean var4) throws ResourceNotFoundException;

    public boolean idRequiresForcedId(String var1);

    @Nonnull
    public List<T> resolveResourcePersistentIdsWithCache(RequestPartitionId var1, List<IIdType> var2);

    public Optional<String> translatePidIdToForcedIdWithCache(T var1);

    public PersistentIdToForcedIdMap<T> translatePidsToForcedIds(Set<T> var1);

    public void addResolvedPidToForcedId(T var1, @Nonnull RequestPartitionId var2, String var3, @Nullable String var4, @Nullable Date var5);

    @Nonnull
    public List<T> getPidsOrThrowException(RequestPartitionId var1, List<IIdType> var2);

    @Nullable
    public T getPidOrNull(RequestPartitionId var1, IBaseResource var2);

    @Nonnull
    public T getPidOrThrowException(RequestPartitionId var1, IIdType var2);

    @Nonnull
    public T getPidOrThrowException(@Nonnull IAnyResource var1);

    public IIdType resourceIdFromPidOrThrowException(T var1, String var2);

    public Set<String> translatePidsToFhirResourceIds(Set<T> var1);

    public T newPid(Object var1);

    public T newPidFromStringIdAndResourceName(String var1, String var2);
}

