/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.expunge;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.model.ExpungeOptions;
import ca.uhn.fhir.jpa.api.model.ExpungeOutcome;
import ca.uhn.fhir.jpa.dao.expunge.ExpungeOperation;
import ca.uhn.fhir.jpa.dao.expunge.IExpungeEverythingService;
import ca.uhn.fhir.jpa.dao.expunge.IResourceExpungeService;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class ExpungeService {
    private static final Logger ourLog = LoggerFactory.getLogger(ExpungeService.class);
    @Autowired
    private IExpungeEverythingService myExpungeEverythingService;
    @Autowired
    private IResourceExpungeService myExpungeDaoService;
    @Autowired
    private ApplicationContext myApplicationContext;

    protected ExpungeOperation getExpungeOperation(String theResourceName, IResourcePersistentId theResourceId, ExpungeOptions theExpungeOptions, RequestDetails theRequestDetails) {
        return (ExpungeOperation)this.myApplicationContext.getBean(ExpungeOperation.class, new Object[]{theResourceName, theResourceId, theExpungeOptions, theRequestDetails});
    }

    public ExpungeOutcome expunge(String theResourceName, IResourcePersistentId theResourceId, ExpungeOptions theExpungeOptions, RequestDetails theRequest) {
        ourLog.info("Expunge: ResourceName[{}] Id[{}] Version[{}] Options[{}]", new Object[]{theResourceName, theResourceId != null ? theResourceId.getId() : null, theResourceId != null ? theResourceId.getVersion() : null, theExpungeOptions});
        ExpungeOperation expungeOperation = this.getExpungeOperation(theResourceName, theResourceId, theExpungeOptions, theRequest);
        if (theExpungeOptions.getLimit() < 1) {
            throw new InvalidRequestException(Msg.code((int)1087) + "Expunge limit may not be less than 1.  Received expunge limit " + theExpungeOptions.getLimit() + ".");
        }
        if (theResourceName == null && (theResourceId == null || theResourceId.getId() == null && theResourceId.getVersion() == null) && theExpungeOptions.isExpungeEverything()) {
            this.myExpungeEverythingService.expungeEverything(theRequest);
            return new ExpungeOutcome().setDeletedCount(this.myExpungeEverythingService.getExpungeDeletedEntityCount());
        }
        return expungeOperation.call();
    }

    public void deleteAllSearchParams(IResourcePersistentId theResourceId) {
        this.myExpungeDaoService.deleteAllSearchParams(theResourceId);
    }
}

