/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.interceptor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.ReadPartitionIdRequestDetails;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.searchparam.extractor.ISearchParamExtractor;
import ca.uhn.fhir.jpa.util.ResourceCompartmentUtil;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.server.exceptions.MethodNotAllowedException;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.IdType;
import org.springframework.beans.factory.annotation.Autowired;

@Interceptor
public class PatientIdPartitionInterceptor {
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private ISearchParamExtractor mySearchParamExtractor;
    @Autowired
    private PartitionSettings myPartitionSettings;

    public PatientIdPartitionInterceptor(FhirContext theFhirContext, ISearchParamExtractor theSearchParamExtractor, PartitionSettings thePartitionSettings) {
        this.myFhirContext = theFhirContext;
        this.mySearchParamExtractor = theSearchParamExtractor;
        this.myPartitionSettings = thePartitionSettings;
    }

    @Hook(value=Pointcut.STORAGE_PARTITION_IDENTIFY_CREATE)
    public RequestPartitionId identifyForCreate(IBaseResource theResource, RequestDetails theRequestDetails) {
        Optional<String> oCompartmentIdentity;
        RuntimeResourceDefinition resourceDef = this.myFhirContext.getResourceDefinition(theResource);
        List<RuntimeSearchParam> compartmentSps = ResourceCompartmentUtil.getPatientCompartmentSearchParams(resourceDef);
        if (compartmentSps.isEmpty()) {
            return this.provideNonCompartmentMemberTypeResponse(theResource);
        }
        if (resourceDef.getName().equals("Patient")) {
            IIdType idElement = theResource.getIdElement();
            oCompartmentIdentity = Optional.ofNullable(idElement.getIdPart());
            if (idElement.isUuid() || oCompartmentIdentity.isEmpty()) {
                throw new MethodNotAllowedException(Msg.code((int)1321) + "Patient resource IDs must be client-assigned in patient compartment mode");
            }
        } else {
            oCompartmentIdentity = ResourceCompartmentUtil.getResourceCompartment("Patient", theResource, compartmentSps, this.mySearchParamExtractor);
        }
        return oCompartmentIdentity.map(ci -> this.provideCompartmentMemberInstanceResponse(theRequestDetails, (String)ci)).orElseGet(() -> this.provideNonCompartmentMemberInstanceResponse(theResource));
    }

    @Hook(value=Pointcut.STORAGE_PARTITION_IDENTIFY_READ)
    public RequestPartitionId identifyForRead(@Nonnull ReadPartitionIdRequestDetails theReadDetails, RequestDetails theRequestDetails) {
        RuntimeResourceDefinition resourceDef;
        List<Object> compartmentSps = Collections.emptyList();
        if (!StringUtils.isEmpty((CharSequence)theReadDetails.getResourceType()) && (compartmentSps = ResourceCompartmentUtil.getPatientCompartmentSearchParams(resourceDef = this.myFhirContext.getResourceDefinition(theReadDetails.getResourceType()))).isEmpty()) {
            return this.provideNonCompartmentMemberTypeResponse(null);
        }
        switch (theReadDetails.getRestOperationType()) {
            case READ: 
            case VREAD: {
                if (!"Patient".equals(theReadDetails.getResourceType())) break;
                return this.provideCompartmentMemberInstanceResponse(theRequestDetails, theReadDetails.getReadResourceId().getIdPart());
            }
            case SEARCH_TYPE: {
                SearchParameterMap params = theReadDetails.getSearchParams();
                assert (params != null);
                if ("Patient".equals(theReadDetails.getResourceType())) {
                    List<String> idParts = this.getResourceIdList(params, "_id", "Patient", false);
                    if (idParts.size() == 1) {
                        return this.provideCompartmentMemberInstanceResponse(theRequestDetails, idParts.get(0));
                    }
                    return RequestPartitionId.allPartitions();
                }
                for (RuntimeSearchParam runtimeSearchParam : compartmentSps) {
                    List<String> idParts = this.getResourceIdList(params, runtimeSearchParam.getName(), "Patient", true);
                    if (idParts.isEmpty()) continue;
                    return this.provideCompartmentMemberInstanceResponse(theRequestDetails, idParts.get(0));
                }
                break;
            }
            case EXTENDED_OPERATION_SERVER: {
                String extendedOp = theReadDetails.getExtendedOperationName();
                if (!"$export".equals(extendedOp) && !"$export-poll-status".equals(extendedOp)) break;
                return this.provideNonPatientSpecificQueryResponse(theReadDetails);
            }
        }
        if (StringUtils.isBlank((CharSequence)theReadDetails.getResourceType())) {
            return this.provideNonCompartmentMemberTypeResponse(null);
        }
        if (theReadDetails.getConditionalTargetOrNull() != null) {
            return this.identifyForCreate(theReadDetails.getConditionalTargetOrNull(), theRequestDetails);
        }
        return this.provideNonPatientSpecificQueryResponse(theReadDetails);
    }

    private List<String> getResourceIdList(SearchParameterMap theParams, String theParamName, String theResourceType, boolean theExpectOnlyOneBool) {
        List idParamAndList = theParams.get(theParamName);
        if (idParamAndList == null) {
            return Collections.emptyList();
        }
        ArrayList<String> idParts = new ArrayList<String>();
        idParamAndList.stream().flatMap(Collection::stream).forEach(idParam -> {
            String chain;
            if (StringUtils.isNotBlank((CharSequence)idParam.getQueryParameterQualifier())) {
                throw new MethodNotAllowedException(Msg.code((int)1322) + "The parameter " + theParamName + idParam.getQueryParameterQualifier() + " is not supported in patient compartment mode");
            }
            if (idParam instanceof ReferenceParam && (chain = ((ReferenceParam)idParam).getChain()) != null) {
                throw new MethodNotAllowedException(Msg.code((int)1323) + "The parameter " + theParamName + "." + chain + " is not supported in patient compartment mode");
            }
            IdType id = new IdType(idParam.getValueAsQueryToken(this.myFhirContext));
            if (!id.hasResourceType() || id.getResourceType().equals(theResourceType)) {
                idParts.add(id.getIdPart());
            }
        });
        if (theExpectOnlyOneBool && idParts.size() > 1) {
            throw new MethodNotAllowedException(Msg.code((int)1324) + "Multiple values for parameter " + theParamName + " is not supported in patient compartment mode");
        }
        return idParts;
    }

    protected RequestPartitionId provideNonPatientSpecificQueryResponse(ReadPartitionIdRequestDetails theRequestDetails) {
        return RequestPartitionId.allPartitions();
    }

    @Nonnull
    protected RequestPartitionId provideCompartmentMemberInstanceResponse(RequestDetails theRequestDetails, String theResourceIdPart) {
        int partitionId = this.providePartitionIdForPatientId(theRequestDetails, theResourceIdPart);
        return RequestPartitionId.fromPartitionIdAndName((Integer)partitionId, (String)theResourceIdPart);
    }

    protected int providePartitionIdForPatientId(RequestDetails theRequestDetails, String theResourceIdPart) {
        return Math.abs(theResourceIdPart.hashCode() % 15000);
    }

    @Nonnull
    protected RequestPartitionId provideNonCompartmentMemberInstanceResponse(IBaseResource theResource) {
        throw new MethodNotAllowedException(Msg.code((int)1326) + "Resource of type " + this.myFhirContext.getResourceType(theResource) + " has no values placing it in the Patient compartment");
    }

    @Nonnull
    protected RequestPartitionId provideNonCompartmentMemberTypeResponse(IBaseResource theResource) {
        return RequestPartitionId.fromPartitionId((Integer)this.myPartitionSettings.getDefaultPartitionId());
    }
}

