/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.interceptor.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.interceptor.validation.BaseTypedRule;
import ca.uhn.fhir.jpa.interceptor.validation.IRepositoryValidatingRule;
import ca.uhn.fhir.jpa.interceptor.validation.RuleRequireProfileDeclaration;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.util.UrlUtil;
import jakarta.annotation.Nonnull;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

class RuleDisallowProfile
extends BaseTypedRule {
    private final Set<String> myProfileUrls;

    RuleDisallowProfile(FhirContext theFhirContext, String theResourceType, String[] theProfileUrls) {
        super(theFhirContext, theResourceType);
        Validate.notNull((Object)theProfileUrls);
        Validate.notEmpty((Object[])theProfileUrls);
        this.myProfileUrls = new HashSet<String>();
        for (String theProfileUrl : theProfileUrls) {
            this.myProfileUrls.add(UrlUtil.normalizeCanonicalUrlForComparison((String)theProfileUrl));
        }
    }

    @Override
    @Nonnull
    public IRepositoryValidatingRule.RuleEvaluation evaluate(RequestDetails theRequestDetails, @Nonnull IBaseResource theResource) {
        for (IPrimitiveType next : theResource.getMeta().getProfile()) {
            String nextUrl = next.getValueAsString();
            String nextUrlNormalized = UrlUtil.normalizeCanonicalUrlForComparison((String)nextUrl);
            if (!this.myProfileUrls.contains(nextUrlNormalized)) continue;
            String msg = this.getFhirContext().getLocalizer().getMessage(RuleRequireProfileDeclaration.class, "illegalProfile", new Object[]{this.getResourceType(), nextUrl});
            return IRepositoryValidatingRule.RuleEvaluation.forFailure((IRepositoryValidatingRule)this, msg);
        }
        return IRepositoryValidatingRule.RuleEvaluation.forSuccess(this);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("resourceType", (Object)this.getResourceType()).append("profiles", this.myProfileUrls).toString();
    }
}

