/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.patch;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.parser.path.EncodeContextPath;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.IModelVisitor2;
import ca.uhn.fhir.util.ParametersUtil;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseEnumeration;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class FhirPatch {
    public static final String OPERATION_ADD = "add";
    public static final String OPERATION_DELETE = "delete";
    public static final String OPERATION_INSERT = "insert";
    public static final String OPERATION_MOVE = "move";
    public static final String OPERATION_REPLACE = "replace";
    public static final String PARAMETER_DESTINATION = "destination";
    public static final String PARAMETER_INDEX = "index";
    public static final String PARAMETER_NAME = "name";
    public static final String PARAMETER_OPERATION = "operation";
    public static final String PARAMETER_PATH = "path";
    public static final String PARAMETER_SOURCE = "source";
    public static final String PARAMETER_TYPE = "type";
    public static final String PARAMETER_VALUE = "value";
    private final FhirContext myContext;
    private boolean myIncludePreviousValueInDiff;
    private Set<EncodeContextPath> myIgnorePaths = Collections.emptySet();

    public FhirPatch(FhirContext theContext) {
        this.myContext = theContext;
    }

    public void addIgnorePath(String theIgnorePath) {
        Validate.notBlank((CharSequence)theIgnorePath, (String)"theIgnorePath must not be null or empty", (Object[])new Object[0]);
        if (this.myIgnorePaths.isEmpty()) {
            this.myIgnorePaths = new HashSet<EncodeContextPath>();
        }
        this.myIgnorePaths.add(new EncodeContextPath(theIgnorePath));
    }

    public void setIncludePreviousValueInDiff(boolean theIncludePreviousValueInDiff) {
        this.myIncludePreviousValueInDiff = theIncludePreviousValueInDiff;
    }

    public void apply(IBaseResource theResource, IBaseResource thePatch) {
        List opParameters = ParametersUtil.getNamedParameters((FhirContext)this.myContext, (IBaseResource)thePatch, (String)PARAMETER_OPERATION);
        for (IBase nextOperation : opParameters) {
            String type = ParametersUtil.getParameterPartValueAsString((FhirContext)this.myContext, (IBase)nextOperation, (String)PARAMETER_TYPE);
            if (OPERATION_DELETE.equals(type = StringUtils.defaultString((String)type))) {
                this.handleDeleteOperation(theResource, nextOperation);
                continue;
            }
            if (OPERATION_ADD.equals(type)) {
                this.handleAddOperation(theResource, nextOperation);
                continue;
            }
            if (OPERATION_REPLACE.equals(type)) {
                this.handleReplaceOperation(theResource, nextOperation);
                continue;
            }
            if (OPERATION_INSERT.equals(type)) {
                this.handleInsertOperation(theResource, nextOperation);
                continue;
            }
            if (OPERATION_MOVE.equals(type)) {
                this.handleMoveOperation(theResource, nextOperation);
                continue;
            }
            throw new InvalidRequestException(Msg.code((int)1267) + "Unknown patch operation type: " + type);
        }
    }

    private void handleAddOperation(IBaseResource theResource, IBase theParameters) {
        String path = ParametersUtil.getParameterPartValueAsString((FhirContext)this.myContext, (IBase)theParameters, (String)PARAMETER_PATH);
        String elementName = ParametersUtil.getParameterPartValueAsString((FhirContext)this.myContext, (IBase)theParameters, (String)PARAMETER_NAME);
        String containingPath = StringUtils.defaultString((String)path);
        List containingElements = this.myContext.newFhirPath().evaluate((IBase)theResource, containingPath, IBase.class);
        for (IBase nextElement : containingElements) {
            ChildDefinition childDefinition = this.findChildDefinition(nextElement, elementName);
            IBase newValue = this.getNewValue(theParameters, nextElement, childDefinition);
            childDefinition.getChildDef().getMutator().addValue(nextElement, newValue);
        }
    }

    private void handleInsertOperation(IBaseResource theResource, IBase theParameters) {
        String path = ParametersUtil.getParameterPartValueAsString((FhirContext)this.myContext, (IBase)theParameters, (String)PARAMETER_PATH);
        path = StringUtils.defaultString((String)path);
        int lastDot = path.lastIndexOf(".");
        String containingPath = path.substring(0, lastDot);
        String elementName = path.substring(lastDot + 1);
        Integer insertIndex = (Integer)ParametersUtil.getParameterPartValueAsInteger((FhirContext)this.myContext, (IBase)theParameters, (String)PARAMETER_INDEX).orElseThrow(() -> new InvalidRequestException("No index supplied for insert operation"));
        List containingElements = this.myContext.newFhirPath().evaluate((IBase)theResource, containingPath, IBase.class);
        for (IBase nextElement : containingElements) {
            ChildDefinition childDefinition = this.findChildDefinition(nextElement, elementName);
            IBase newValue = this.getNewValue(theParameters, nextElement, childDefinition);
            ArrayList<IBase> existingValues = new ArrayList<IBase>(childDefinition.getChildDef().getAccessor().getValues(nextElement));
            if (insertIndex == null || insertIndex < 0 || insertIndex > existingValues.size()) {
                String msg = this.myContext.getLocalizer().getMessage(FhirPatch.class, "invalidInsertIndex", new Object[]{insertIndex, path, existingValues.size()});
                throw new InvalidRequestException(Msg.code((int)1270) + msg);
            }
            existingValues.add(insertIndex, newValue);
            childDefinition.getChildDef().getMutator().setValue(nextElement, null);
            for (IBase nextNewValue : existingValues) {
                childDefinition.getChildDef().getMutator().addValue(nextElement, nextNewValue);
            }
        }
    }

    private void handleDeleteOperation(IBaseResource theResource, IBase theParameters) {
        String elementName;
        String containingPath;
        int lastDotIndex;
        String path = ParametersUtil.getParameterPartValueAsString((FhirContext)this.myContext, (IBase)theParameters, (String)PARAMETER_PATH);
        if ((path = StringUtils.defaultString((String)path)).endsWith(")")) {
            int filterArgsIndex = path.lastIndexOf(40);
            lastDotIndex = path.lastIndexOf(46, filterArgsIndex);
            int secondLastDotIndex = path.lastIndexOf(46, lastDotIndex - 1);
            containingPath = path.substring(0, secondLastDotIndex);
            elementName = path.substring(secondLastDotIndex + 1, lastDotIndex);
        } else if (path.endsWith("]")) {
            int openBracketIndex = path.lastIndexOf(91);
            lastDotIndex = path.lastIndexOf(46, openBracketIndex);
            containingPath = path.substring(0, lastDotIndex);
            elementName = path.substring(lastDotIndex + 1, openBracketIndex);
        } else {
            containingPath = path;
            elementName = null;
        }
        List containingElements = this.myContext.newFhirPath().evaluate((IBase)theResource, containingPath, IBase.class);
        for (IBase nextElement : containingElements) {
            if (elementName == null) {
                this.deleteSingleElement(nextElement);
                continue;
            }
            this.deleteFromList(theResource, nextElement, elementName, path);
        }
    }

    private void deleteFromList(IBaseResource theResource, IBase theContainingElement, String theListElementName, String theElementToDeletePath) {
        ChildDefinition childDefinition = this.findChildDefinition(theContainingElement, theListElementName);
        ArrayList existingValues = new ArrayList(childDefinition.getChildDef().getAccessor().getValues(theContainingElement));
        List elementsToRemove = this.myContext.newFhirPath().evaluate((IBase)theResource, theElementToDeletePath, IBase.class);
        existingValues.removeAll(elementsToRemove);
        childDefinition.getChildDef().getMutator().setValue(theContainingElement, null);
        for (IBase nextNewValue : existingValues) {
            childDefinition.getChildDef().getMutator().addValue(theContainingElement, nextNewValue);
        }
    }

    private void handleReplaceOperation(IBaseResource theResource, IBase theParameters) {
        String path = ParametersUtil.getParameterPartValueAsString((FhirContext)this.myContext, (IBase)theParameters, (String)PARAMETER_PATH);
        path = StringUtils.defaultString((String)path);
        int lastDot = path.lastIndexOf(".");
        String containingPath = path.substring(0, lastDot);
        String elementName = path.substring(lastDot + 1);
        List containingElements = this.myContext.newFhirPath().evaluate((IBase)theResource, containingPath, IBase.class);
        for (IBase nextElement : containingElements) {
            ChildDefinition childDefinition = this.findChildDefinition(nextElement, elementName);
            IBase newValue = this.getNewValue(theParameters, nextElement, childDefinition);
            childDefinition.getChildDef().getMutator().setValue(nextElement, newValue);
        }
    }

    private void handleMoveOperation(IBaseResource theResource, IBase theParameters) {
        String path = ParametersUtil.getParameterPartValueAsString((FhirContext)this.myContext, (IBase)theParameters, (String)PARAMETER_PATH);
        path = StringUtils.defaultString((String)path);
        int lastDot = path.lastIndexOf(".");
        String containingPath = path.substring(0, lastDot);
        String elementName = path.substring(lastDot + 1);
        Integer insertIndex = (Integer)ParametersUtil.getParameterPartValueAsInteger((FhirContext)this.myContext, (IBase)theParameters, (String)PARAMETER_DESTINATION).orElseThrow(() -> new InvalidRequestException("No index supplied for move operation"));
        Integer removeIndex = (Integer)ParametersUtil.getParameterPartValueAsInteger((FhirContext)this.myContext, (IBase)theParameters, (String)PARAMETER_SOURCE).orElseThrow(() -> new InvalidRequestException("No index supplied for move operation"));
        List containingElements = this.myContext.newFhirPath().evaluate((IBase)theResource, containingPath, IBase.class);
        for (IBase nextElement : containingElements) {
            ChildDefinition childDefinition = this.findChildDefinition(nextElement, elementName);
            ArrayList<IBase> existingValues = new ArrayList<IBase>(childDefinition.getChildDef().getAccessor().getValues(nextElement));
            if (removeIndex == null || removeIndex < 0 || removeIndex >= existingValues.size()) {
                String msg = this.myContext.getLocalizer().getMessage(FhirPatch.class, "invalidMoveSourceIndex", new Object[]{removeIndex, path, existingValues.size()});
                throw new InvalidRequestException(Msg.code((int)1268) + msg);
            }
            IBase newValue = (IBase)existingValues.remove(removeIndex);
            if (insertIndex == null || insertIndex < 0 || insertIndex > existingValues.size()) {
                String msg = this.myContext.getLocalizer().getMessage(FhirPatch.class, "invalidMoveDestinationIndex", new Object[]{insertIndex, path, existingValues.size()});
                throw new InvalidRequestException(Msg.code((int)1269) + msg);
            }
            existingValues.add(insertIndex, newValue);
            childDefinition.getChildDef().getMutator().setValue(nextElement, null);
            for (IBase nextNewValue : existingValues) {
                childDefinition.getChildDef().getMutator().addValue(nextElement, nextNewValue);
            }
        }
    }

    private ChildDefinition findChildDefinition(IBase theContainingElement, String theElementName) {
        BaseRuntimeElementDefinition childElement;
        Object childName;
        BaseRuntimeElementDefinition elementDef = this.myContext.getElementDefinition(theContainingElement.getClass());
        BaseRuntimeChildDefinition childDef = elementDef.getChildByName((String)(childName = theElementName));
        if (childDef == null) {
            childName = theElementName + "[x]";
            childDef = elementDef.getChildByName((String)childName);
            childElement = childDef.getChildByName((String)childDef.getValidChildNames().iterator().next());
        } else {
            childElement = childDef.getChildByName((String)childName);
        }
        return new ChildDefinition(childDef, childElement);
    }

    private IBase getNewValue(IBase theParameters, IBase theElement, ChildDefinition theChildDefinition) {
        IBase newValue;
        Optional valuePart = ParametersUtil.getParameterPart((FhirContext)this.myContext, (IBase)theParameters, (String)PARAMETER_VALUE);
        Optional valuePartValue = ParametersUtil.getParameterPartValue((FhirContext)this.myContext, (IBase)theParameters, (String)PARAMETER_VALUE);
        if (valuePartValue.isPresent()) {
            newValue = (IBase)valuePartValue.get();
        } else {
            List<IBase> partParts = valuePart.map(this::extractPartsFromPart).orElse(Collections.emptyList());
            newValue = this.createAndPopulateNewElement(theChildDefinition, partParts);
        }
        if (IBaseEnumeration.class.isAssignableFrom(theChildDefinition.getChildElement().getImplementingClass()) || XhtmlNode.class.isAssignableFrom(theChildDefinition.getChildElement().getImplementingClass())) {
            IPrimitiveType newValueInstance = theChildDefinition.getChildDef().getInstanceConstructorArguments() != null ? (IPrimitiveType)theChildDefinition.getChildElement().newInstance(theChildDefinition.getChildDef().getInstanceConstructorArguments()) : (IPrimitiveType)theChildDefinition.getChildElement().newInstance();
            newValueInstance.setValueAsString(((IPrimitiveType)newValue).getValueAsString());
            theChildDefinition.getChildDef().getMutator().setValue(theElement, (IBase)newValueInstance);
            newValue = newValueInstance;
        }
        return newValue;
    }

    @Nonnull
    private List<IBase> extractPartsFromPart(IBase theParametersParameterComponent) {
        return this.myContext.newTerser().getValues(theParametersParameterComponent, "part");
    }

    private IBase createAndPopulateNewElement(ChildDefinition theDefinition, List<IBase> thePartParts) {
        IBase newElement = theDefinition.getChildElement().newInstance();
        for (IBase nextValuePartPart : thePartParts) {
            Object name = this.myContext.newTerser().getSingleValue(nextValuePartPart, PARAMETER_NAME, IPrimitiveType.class).map(IPrimitiveType::getValueAsString).orElse(null);
            if (StringUtils.isBlank((CharSequence)name)) continue;
            Optional value = this.myContext.newTerser().getSingleValue(nextValuePartPart, "value[x]", IBase.class);
            if (value.isPresent()) {
                BaseRuntimeChildDefinition partChildDef = theDefinition.getChildElement().getChildByName((String)name);
                if (partChildDef == null) {
                    name = (String)name + "[x]";
                    partChildDef = theDefinition.getChildElement().getChildByName((String)name);
                }
                partChildDef.getMutator().addValue(newElement, (IBase)value.get());
                continue;
            }
            List<IBase> part = this.extractPartsFromPart(nextValuePartPart);
            if (part.isEmpty()) continue;
            ChildDefinition childDefinition = this.findChildDefinition(newElement, (String)name);
            IBase childNewValue = this.createAndPopulateNewElement(childDefinition, part);
            childDefinition.getChildDef().getMutator().setValue(newElement, childNewValue);
        }
        return newElement;
    }

    private void deleteSingleElement(IBase theElementToDelete) {
        this.myContext.newTerser().visit(theElementToDelete, new IModelVisitor2(){

            public boolean acceptElement(IBase theElement, List<IBase> theContainingElementPath, List<BaseRuntimeChildDefinition> theChildDefinitionPath, List<BaseRuntimeElementDefinition<?>> theElementDefinitionPath) {
                if (theElement instanceof IPrimitiveType) {
                    ((IPrimitiveType)theElement).setValueAsString(null);
                }
                return true;
            }
        });
    }

    public IBaseParameters diff(@Nullable IBaseResource theOldValue, @Nonnull IBaseResource theNewValue) {
        IBaseParameters retVal = ParametersUtil.newInstance((FhirContext)this.myContext);
        String newValueTypeName = this.myContext.getResourceDefinition(theNewValue).getName();
        if (theOldValue == null) {
            IBase operation = ParametersUtil.addParameterToParameters((FhirContext)this.myContext, (IBaseParameters)retVal, (String)PARAMETER_OPERATION);
            ParametersUtil.addPartCode((FhirContext)this.myContext, (IBase)operation, (String)PARAMETER_TYPE, (String)OPERATION_INSERT);
            ParametersUtil.addPartString((FhirContext)this.myContext, (IBase)operation, (String)PARAMETER_PATH, (String)newValueTypeName);
            ParametersUtil.addPart((FhirContext)this.myContext, (IBase)operation, (String)PARAMETER_VALUE, (IBase)theNewValue);
        } else {
            String oldValueTypeName = this.myContext.getResourceDefinition(theOldValue).getName();
            Validate.isTrue((boolean)oldValueTypeName.equalsIgnoreCase(newValueTypeName), (String)"Resources must be of same type", (Object[])new Object[0]);
            RuntimeResourceDefinition def = this.myContext.getResourceDefinition(theOldValue).getBaseDefinition();
            String path = def.getName();
            EncodeContextPath contextPath = new EncodeContextPath();
            contextPath.pushPath(path, true);
            this.compare(retVal, contextPath, (BaseRuntimeElementDefinition<?>)def, path, path, (IBase)theOldValue, (IBase)theNewValue);
            contextPath.popPath();
            assert (contextPath.getPath().isEmpty());
        }
        return retVal;
    }

    private void compare(IBaseParameters theDiff, EncodeContextPath theSourceEncodeContext, BaseRuntimeElementDefinition<?> theDef, String theSourcePath, String theTargetPath, IBase theOldField, IBase theNewField) {
        boolean pathIsIgnored = this.pathIsIgnored(theSourceEncodeContext);
        if (pathIsIgnored) {
            return;
        }
        BaseRuntimeElementDefinition sourceDef = this.myContext.getElementDefinition(theOldField.getClass());
        BaseRuntimeElementDefinition targetDef = this.myContext.getElementDefinition(theNewField.getClass());
        if (!sourceDef.getName().equals(targetDef.getName())) {
            IBase operation = ParametersUtil.addParameterToParameters((FhirContext)this.myContext, (IBaseParameters)theDiff, (String)PARAMETER_OPERATION);
            ParametersUtil.addPartCode((FhirContext)this.myContext, (IBase)operation, (String)PARAMETER_TYPE, (String)OPERATION_REPLACE);
            ParametersUtil.addPartString((FhirContext)this.myContext, (IBase)operation, (String)PARAMETER_PATH, (String)theTargetPath);
            this.addValueToDiff(operation, theOldField, theNewField);
        } else {
            if (theOldField instanceof IPrimitiveType) {
                String newValueAsString;
                IPrimitiveType oldPrimitive = (IPrimitiveType)theOldField;
                IPrimitiveType newPrimitive = (IPrimitiveType)theNewField;
                String oldValueAsString = this.toValue(oldPrimitive);
                if (!Objects.equals(oldValueAsString, newValueAsString = this.toValue(newPrimitive))) {
                    IBase operation = ParametersUtil.addParameterToParameters((FhirContext)this.myContext, (IBaseParameters)theDiff, (String)PARAMETER_OPERATION);
                    ParametersUtil.addPartCode((FhirContext)this.myContext, (IBase)operation, (String)PARAMETER_TYPE, (String)OPERATION_REPLACE);
                    ParametersUtil.addPartString((FhirContext)this.myContext, (IBase)operation, (String)PARAMETER_PATH, (String)theTargetPath);
                    this.addValueToDiff(operation, (IBase)oldPrimitive, (IBase)newPrimitive);
                }
            }
            List children = theDef.getChildren();
            for (BaseRuntimeChildDefinition nextChild : children) {
                this.compareField(theDiff, theSourceEncodeContext, theSourcePath, theTargetPath, theOldField, theNewField, nextChild);
            }
        }
    }

    private void compareField(IBaseParameters theDiff, EncodeContextPath theSourceEncodePath, String theSourcePath, String theTargetPath, IBase theOldField, IBase theNewField, BaseRuntimeChildDefinition theChildDef) {
        int targetIndex;
        String elementName = theChildDef.getElementName();
        boolean repeatable = theChildDef.getMax() != 1;
        theSourceEncodePath.pushPath(elementName, false);
        if (this.pathIsIgnored(theSourceEncodePath)) {
            theSourceEncodePath.popPath();
            return;
        }
        List sourceValues = theChildDef.getAccessor().getValues(theOldField);
        List targetValues = theChildDef.getAccessor().getValues(theNewField);
        int sourceIndex = 0;
        for (targetIndex = 0; sourceIndex < sourceValues.size() && targetIndex < targetValues.size(); ++sourceIndex, ++targetIndex) {
            IBase sourceChildField = (IBase)sourceValues.get(sourceIndex);
            Validate.notNull((Object)sourceChildField);
            BaseRuntimeElementDefinition def = this.myContext.getElementDefinition(sourceChildField.getClass());
            IBase targetChildField = (IBase)targetValues.get(targetIndex);
            Validate.notNull((Object)targetChildField);
            String sourcePath = theSourcePath + "." + elementName + (String)(repeatable ? "[" + sourceIndex + "]" : "");
            String targetPath = theSourcePath + "." + elementName + (String)(repeatable ? "[" + targetIndex + "]" : "");
            this.compare(theDiff, theSourceEncodePath, def, sourcePath, targetPath, sourceChildField, targetChildField);
        }
        while (targetIndex < targetValues.size()) {
            String path = theTargetPath + "." + elementName;
            this.addInsertItems(theDiff, targetValues, targetIndex, path, theChildDef);
            ++targetIndex;
        }
        while (sourceIndex < sourceValues.size()) {
            IBase operation = ParametersUtil.addParameterToParameters((FhirContext)this.myContext, (IBaseParameters)theDiff, (String)PARAMETER_OPERATION);
            ParametersUtil.addPartCode((FhirContext)this.myContext, (IBase)operation, (String)PARAMETER_TYPE, (String)OPERATION_DELETE);
            ParametersUtil.addPartString((FhirContext)this.myContext, (IBase)operation, (String)PARAMETER_PATH, (String)(theTargetPath + "." + elementName + (String)(repeatable ? "[" + targetIndex + "]" : "")));
            ++sourceIndex;
            ++targetIndex;
        }
        theSourceEncodePath.popPath();
    }

    private void addInsertItems(IBaseParameters theDiff, List<? extends IBase> theTargetValues, int theTargetIndex, String thePath, BaseRuntimeChildDefinition theChildDefinition) {
        IBase operation = ParametersUtil.addParameterToParameters((FhirContext)this.myContext, (IBaseParameters)theDiff, (String)PARAMETER_OPERATION);
        ParametersUtil.addPartCode((FhirContext)this.myContext, (IBase)operation, (String)PARAMETER_TYPE, (String)OPERATION_INSERT);
        ParametersUtil.addPartString((FhirContext)this.myContext, (IBase)operation, (String)PARAMETER_PATH, (String)thePath);
        ParametersUtil.addPartInteger((FhirContext)this.myContext, (IBase)operation, (String)PARAMETER_INDEX, (Integer)theTargetIndex);
        IBase value = theTargetValues.get(theTargetIndex);
        BaseRuntimeElementDefinition valueDef = this.myContext.getElementDefinition(value.getClass());
        if (valueDef.isStandardType()) {
            ParametersUtil.addPart((FhirContext)this.myContext, (IBase)operation, (String)PARAMETER_VALUE, (IBase)value);
        } else {
            for (BaseRuntimeChildDefinition nextChild : valueDef.getChildren()) {
                List childValues = nextChild.getAccessor().getValues(value);
                for (int index = 0; index < childValues.size(); ++index) {
                    boolean childRepeatable = theChildDefinition.getMax() != 1;
                    String elementName = nextChild.getChildNameByDatatype(((IBase)childValues.get(index)).getClass());
                    String targetPath = thePath + (String)(childRepeatable ? "[" + index + "]" : "") + "." + elementName;
                    this.addInsertItems(theDiff, childValues, index, targetPath, nextChild);
                }
            }
        }
    }

    private void addValueToDiff(IBase theOperationPart, IBase theOldValue, IBase theNewValue) {
        if (this.myIncludePreviousValueInDiff) {
            IBase oldValue = this.massageValueForDiff(theOldValue);
            ParametersUtil.addPart((FhirContext)this.myContext, (IBase)theOperationPart, (String)"previousValue", (IBase)oldValue);
        }
        IBase newValue = this.massageValueForDiff(theNewValue);
        ParametersUtil.addPart((FhirContext)this.myContext, (IBase)theOperationPart, (String)PARAMETER_VALUE, (IBase)newValue);
    }

    private boolean pathIsIgnored(EncodeContextPath theSourceEncodeContext) {
        boolean pathIsIgnored = false;
        for (EncodeContextPath next : this.myIgnorePaths) {
            if (!theSourceEncodeContext.startsWith(next, false)) continue;
            pathIsIgnored = true;
            break;
        }
        return pathIsIgnored;
    }

    private IBase massageValueForDiff(IBase theNewValue) {
        IBase massagedValue = theNewValue;
        if (theNewValue instanceof XhtmlNode) {
            String xhtmlString = ((XhtmlNode)theNewValue).getValueAsString();
            massagedValue = this.myContext.getElementDefinition("string").newInstance((Object)xhtmlString);
        }
        if (theNewValue instanceof IIdType) {
            String idPart = ((IIdType)theNewValue).getIdPart();
            massagedValue = this.myContext.getElementDefinition("id").newInstance((Object)idPart);
        }
        return massagedValue;
    }

    private String toValue(IPrimitiveType<?> theOldPrimitive) {
        if (theOldPrimitive instanceof IIdType) {
            return ((IIdType)theOldPrimitive).getIdPart();
        }
        return theOldPrimitive.getValueAsString();
    }

    private static class ChildDefinition {
        private final BaseRuntimeChildDefinition myChildDef;
        private final BaseRuntimeElementDefinition<?> myChildElement;

        public ChildDefinition(BaseRuntimeChildDefinition theChildDef, BaseRuntimeElementDefinition<?> theChildElement) {
            this.myChildDef = theChildDef;
            this.myChildElement = theChildElement;
        }

        public BaseRuntimeChildDefinition getChildDef() {
            return this.myChildDef;
        }

        public BaseRuntimeElementDefinition<?> getChildElement() {
            return this.myChildElement;
        }
    }
}

