/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider;

import ca.uhn.fhir.jpa.api.dao.IFhirSystemDao;
import ca.uhn.fhir.jpa.api.model.ExpungeOptions;
import ca.uhn.fhir.jpa.api.model.ExpungeOutcome;
import ca.uhn.fhir.jpa.provider.BaseJpaProvider;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public abstract class BaseStorageSystemProvider<T, MT>
extends BaseJpaProvider {
    protected IFhirSystemDao<T, MT> myDao;

    @Operation(name="$expunge", idempotent=false, returnParameters={@OperationParam(name="count", typeName="integer")})
    public IBaseParameters expunge(@OperationParam(name="limit", typeName="integer") IPrimitiveType<Integer> theLimit, @OperationParam(name="expungeDeletedResources", typeName="boolean") IPrimitiveType<Boolean> theExpungeDeletedResources, @OperationParam(name="expungePreviousVersions", typeName="boolean") IPrimitiveType<Boolean> theExpungeOldVersions, @OperationParam(name="expungeEverything", typeName="boolean") IPrimitiveType<Boolean> theExpungeEverything, RequestDetails theRequestDetails) {
        return this.doExpunge(theLimit, theExpungeDeletedResources, theExpungeOldVersions, theExpungeEverything, theRequestDetails);
    }

    protected IBaseParameters doExpunge(IPrimitiveType<? extends Integer> theLimit, IPrimitiveType<? extends Boolean> theExpungeDeletedResources, IPrimitiveType<? extends Boolean> theExpungeOldVersions, IPrimitiveType<? extends Boolean> theExpungeEverything, RequestDetails theRequestDetails) {
        ExpungeOptions options = this.createExpungeOptions(theLimit, theExpungeDeletedResources, theExpungeOldVersions, theExpungeEverything);
        ExpungeOutcome outcome = this.getDao().expunge(options, theRequestDetails);
        return this.createExpungeResponse(outcome);
    }

    protected IFhirSystemDao<T, MT> getDao() {
        return this.myDao;
    }

    public void setDao(IFhirSystemDao<T, MT> theDao) {
        this.myDao = theDao;
    }
}

