/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.searchparam.extractor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.dao.BaseStorageDao;
import ca.uhn.fhir.jpa.dao.MatchResourceUrlService;
import ca.uhn.fhir.jpa.dao.index.DaoResourceLinkResolver;
import ca.uhn.fhir.jpa.model.cross.IBasePersistedResource;
import ca.uhn.fhir.jpa.searchparam.extractor.ISearchParamWithInlineReferencesExtractor;
import ca.uhn.fhir.jpa.util.MemoryCacheService;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.util.FhirTerser;
import ca.uhn.fhir.util.UrlUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseSearchParamWithInlineReferencesExtractor<T extends IResourcePersistentId>
implements ISearchParamWithInlineReferencesExtractor {
    private static final Logger ourLog = LoggerFactory.getLogger(BaseSearchParamWithInlineReferencesExtractor.class);
    protected FhirContext myFhirContext;
    protected JpaStorageSettings myStorageSettings;
    @Autowired
    private MatchResourceUrlService<T> myMatchResourceUrlService;
    @Autowired
    private DaoResourceLinkResolver<T> myDaoResourceLinkResolver;
    @Autowired
    private MemoryCacheService myMemoryCacheService;
    @Autowired
    private IIdHelperService<T> myIdHelperService;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void extractInlineReferences(RequestDetails theRequestDetails, IBaseResource theResource, TransactionDetails theTransactionDetails) {
        FhirTerser terser = this.myFhirContext.newTerser();
        List allRefs = terser.getAllPopulatedChildElementsOfType(theResource, IBaseReference.class);
        Iterator iterator = allRefs.iterator();
        while (iterator.hasNext()) {
            IResourcePersistentId match;
            int qmIndex;
            IBaseReference nextRef = (IBaseReference)iterator.next();
            IIdType nextId = nextRef.getReferenceElement();
            String nextIdText = nextId.getValue();
            if (nextIdText == null || (qmIndex = nextIdText.indexOf(63)) == -1) continue;
            if (!this.myStorageSettings.isAllowInlineMatchUrlReferences()) {
                String msg = this.myFhirContext.getLocalizer().getMessage(BaseStorageDao.class, "inlineMatchNotSupported", new Object[]{UrlUtil.sanitizeUrlPart((CharSequence)nextRef.getReferenceElement().getValueAsString())});
                throw new InvalidRequestException(Msg.code((int)2282) + msg);
            }
            String resourceTypeString = (nextIdText = BaseSearchParamWithInlineReferencesExtractor.truncateReference(nextIdText, qmIndex)).substring(0, nextIdText.indexOf(63)).replace("/", "");
            RuntimeResourceDefinition matchResourceDef = this.myFhirContext.getResourceDefinition(resourceTypeString);
            if (matchResourceDef == null) {
                String msg = this.myFhirContext.getLocalizer().getMessage(BaseStorageDao.class, "invalidMatchUrlInvalidResourceType", new Object[]{nextId.getValue(), resourceTypeString});
                throw new InvalidRequestException(Msg.code((int)1090) + msg);
            }
            Class matchResourceType = matchResourceDef.getImplementingClass();
            IResourcePersistentId resolvedMatch = null;
            if (theTransactionDetails != null) {
                resolvedMatch = (IResourcePersistentId)theTransactionDetails.getResolvedMatchUrls().get(nextIdText);
            }
            Set<Object> matches = resolvedMatch != null && !IResourcePersistentId.NOT_FOUND.equals(resolvedMatch) ? Set.of(resolvedMatch) : this.myMatchResourceUrlService.processMatchUrl(nextIdText, matchResourceType, theTransactionDetails, theRequestDetails);
            IIdType newId = null;
            if (matches.isEmpty()) {
                Optional<IBasePersistedResource> placeholderOpt = this.myDaoResourceLinkResolver.createPlaceholderTargetIfConfiguredToDoSo(matchResourceType, nextRef, null, theRequestDetails, theTransactionDetails);
                if (!placeholderOpt.isPresent()) {
                    String msg = this.myFhirContext.getLocalizer().getMessage(BaseStorageDao.class, "invalidMatchUrlNoMatches", new Object[]{nextId.getValue()});
                    throw new ResourceNotFoundException(Msg.code((int)1091) + msg);
                }
                match = placeholderOpt.get().getPersistentId();
                newId = this.myFhirContext.getVersion().newIdType();
                newId.setValue(placeholderOpt.get().getIdDt().getValue());
                match.setAssociatedResourceId(newId);
                theTransactionDetails.addResolvedMatchUrl(this.myFhirContext, nextIdText, match);
                this.myMemoryCacheService.putAfterCommit(MemoryCacheService.CacheEnum.MATCH_URL, nextIdText, match);
            } else {
                if (matches.size() > 1) {
                    String msg = this.myFhirContext.getLocalizer().getMessage(TransactionDetails.class, "invalidMatchUrlMultipleMatches", new Object[]{nextId.getValue()});
                    throw new PreconditionFailedException(Msg.code((int)1092) + msg);
                }
                match = (IResourcePersistentId)matches.iterator().next();
            }
            if (newId == null) {
                newId = this.myIdHelperService.translatePidIdToForcedId(this.myFhirContext, resourceTypeString, match);
            }
            ourLog.debug("Replacing inline match URL[{}] with ID[{}}", (Object)nextId.getValue(), newId);
            if (theTransactionDetails != null) {
                String previousReference = nextRef.getReferenceElement().getValue();
                theTransactionDetails.addRollbackUndoAction(() -> nextRef.setReference(previousReference));
            }
            nextRef.setReference(newId.getValue());
        }
        return;
    }

    private static String truncateReference(String nextIdText, int qmIndex) {
        for (int i = qmIndex - 1; i >= 0; --i) {
            if (nextIdText.charAt(i) != '/' || i < nextIdText.length() - 1 && nextIdText.charAt(i + 1) == '?') continue;
            nextIdText = nextIdText.substring(i + 1);
            break;
        }
        return nextIdText;
    }

    @Autowired
    public void setStorageSettings(JpaStorageSettings theStorageSettings) {
        this.myStorageSettings = theStorageSettings;
    }

    @Autowired
    public void setContext(FhirContext theContext) {
        this.myFhirContext = theContext;
    }
}

