/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.channel.impl;

import ca.uhn.fhir.util.BaseUnrecoverableRuntimeException;
import jakarta.annotation.Nonnull;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryListener;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.listener.RetryListenerSupport;
import org.springframework.retry.policy.TimeoutRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.transaction.CannotCreateTransactionException;

class RetryingMessageHandlerWrapper
implements MessageHandler {
    private static final Logger ourLog = LoggerFactory.getLogger(RetryingMessageHandlerWrapper.class);
    private final MessageHandler myWrap;
    private final String myChannelName;

    RetryingMessageHandlerWrapper(MessageHandler theWrap, String theChannelName) {
        this.myWrap = theWrap;
        this.myChannelName = theChannelName;
    }

    public void handleMessage(@Nonnull Message<?> theMessage) throws MessagingException {
        RetryTemplate retryTemplate = new RetryTemplate();
        ExponentialBackOffPolicy backOffPolicy = new ExponentialBackOffPolicy();
        backOffPolicy.setInitialInterval(1000L);
        backOffPolicy.setMultiplier(1.1);
        retryTemplate.setBackOffPolicy((BackOffPolicy)backOffPolicy);
        TimeoutRetryPolicy retryPolicy = new TimeoutRetryPolicy();
        retryPolicy.setTimeout(60000L);
        retryTemplate.setRetryPolicy((RetryPolicy)retryPolicy);
        retryTemplate.setThrowLastExceptionOnExhausted(true);
        RetryListenerSupport retryListener = new RetryListenerSupport(){

            public <T, E extends Throwable> void onError(RetryContext theContext, RetryCallback<T, E> theCallback, Throwable theThrowable) {
                ourLog.error("Failure {} processing message in channel[{}]: {}", new Object[]{theContext.getRetryCount(), RetryingMessageHandlerWrapper.this.myChannelName, theThrowable.toString()});
                ourLog.error("Failure", theThrowable);
                if (theThrowable instanceof BaseUnrecoverableRuntimeException) {
                    theContext.setExhaustedOnly();
                }
                if (ExceptionUtils.indexOfThrowable((Throwable)theThrowable, CannotCreateTransactionException.class) != -1) {
                    theContext.setExhaustedOnly();
                }
            }
        };
        retryTemplate.setListeners(new RetryListener[]{retryListener});
        retryTemplate.execute(context -> {
            this.myWrap.handleMessage(theMessage);
            return null;
        });
    }

    public MessageHandler getWrappedHandler() {
        return this.myWrap;
    }
}

