/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.model;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.messaging.BaseResourceMessage;
import ca.uhn.fhir.rest.server.messaging.BaseResourceModifiedMessage;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public class ResourceModifiedMessage
extends BaseResourceModifiedMessage {
    @JsonProperty(value="subscriptionId")
    private String mySubscriptionId;

    public ResourceModifiedMessage() {
    }

    public ResourceModifiedMessage(IIdType theIdType, BaseResourceMessage.OperationTypeEnum theOperationType) {
        super(theIdType, theOperationType);
        this.setPartitionId(RequestPartitionId.defaultPartition());
    }

    public ResourceModifiedMessage(FhirContext theFhirContext, IBaseResource theResource, BaseResourceMessage.OperationTypeEnum theOperationType) {
        super(theFhirContext, theResource, theOperationType);
        this.setPartitionId(RequestPartitionId.defaultPartition());
    }

    public ResourceModifiedMessage(FhirContext theFhirContext, IBaseResource theResource, BaseResourceMessage.OperationTypeEnum theOperationType, RequestPartitionId theRequestPartitionId) {
        super(theFhirContext, theResource, theOperationType);
        this.setPartitionId(theRequestPartitionId);
    }

    public ResourceModifiedMessage(FhirContext theFhirContext, IBaseResource theNewResource, BaseResourceMessage.OperationTypeEnum theOperationType, RequestDetails theRequest) {
        super(theFhirContext, theNewResource, theOperationType, theRequest);
        this.setPartitionId(RequestPartitionId.defaultPartition());
    }

    public ResourceModifiedMessage(FhirContext theFhirContext, IBaseResource theNewResource, BaseResourceMessage.OperationTypeEnum theOperationType, RequestDetails theRequest, RequestPartitionId theRequestPartitionId) {
        super(theFhirContext, theNewResource, theOperationType, theRequest, theRequestPartitionId);
    }

    public String getSubscriptionId() {
        return this.mySubscriptionId;
    }

    public void setSubscriptionId(String theSubscriptionId) {
        this.mySubscriptionId = theSubscriptionId;
    }

    public void setPayloadToNull() {
        this.myPayload = null;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("operationType", (Object)this.myOperationType).append("subscriptionId", (Object)this.mySubscriptionId).append("payloadId", (Object)this.myPayloadId).append("partitionId", (Object)this.myPartitionId).toString();
    }

    public boolean equals(Object theO) {
        if (this == theO) {
            return true;
        }
        if (theO == null || ((Object)((Object)this)).getClass() != theO.getClass()) {
            return false;
        }
        if (!super.equals(theO)) {
            return false;
        }
        ResourceModifiedMessage that = (ResourceModifiedMessage)((Object)theO);
        return Objects.equals(this.getSubscriptionId(), that.getSubscriptionId());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSubscriptionId());
    }
}

