/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.util;

import ca.uhn.fhir.jpa.util.BaseCaptureQueriesListener;
import ca.uhn.fhir.jpa.util.SqlQuery;
import ca.uhn.fhir.util.StopWatch;
import com.google.common.collect.Queues;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.hl7.fhir.r4.model.InstantType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CircularQueueCaptureQueriesListener
extends BaseCaptureQueriesListener {
    public static final Predicate<String> DEFAULT_SELECT_INCLUSION_CRITERIA = t -> t.toLowerCase(Locale.US).startsWith("select");
    private static final int CAPACITY = 1000;
    private static final Logger ourLog = LoggerFactory.getLogger(CircularQueueCaptureQueriesListener.class);
    private Queue<SqlQuery> myQueries;
    private AtomicInteger myCommitCounter;
    private AtomicInteger myRollbackCounter;
    @Nonnull
    private Predicate<String> mySelectQueryInclusionCriteria = DEFAULT_SELECT_INCLUSION_CRITERIA;

    public CircularQueueCaptureQueriesListener() {
        this.startCollecting();
    }

    public CircularQueueCaptureQueriesListener setSelectQueryInclusionCriteria(@Nonnull Predicate<String> theSelectQueryInclusionCriteria) {
        this.mySelectQueryInclusionCriteria = theSelectQueryInclusionCriteria;
        return this;
    }

    @Override
    protected Queue<SqlQuery> provideQueryList() {
        return this.myQueries;
    }

    @Override
    protected AtomicInteger provideCommitCounter() {
        return this.myCommitCounter;
    }

    @Override
    protected AtomicInteger provideRollbackCounter() {
        return this.myRollbackCounter;
    }

    public void clear() {
        this.myQueries.clear();
        this.myCommitCounter.set(0);
        this.myRollbackCounter.set(0);
    }

    public void startCollecting() {
        this.myQueries = Queues.synchronizedQueue((Queue)new CircularFifoQueue(1000));
        this.myCommitCounter = new AtomicInteger(0);
        this.myRollbackCounter = new AtomicInteger(0);
    }

    public void stopCollecting() {
        this.myQueries = null;
        this.myCommitCounter = null;
        this.myRollbackCounter = null;
    }

    public List<SqlQuery> getCapturedQueries() {
        ArrayList retVal = new ArrayList(1000);
        this.myQueries.forEach(retVal::add);
        return Collections.unmodifiableList(retVal);
    }

    private List<SqlQuery> getQueriesForCurrentThreadStartingWith(String theStart) {
        String threadName = Thread.currentThread().getName();
        return this.getQueriesStartingWith(theStart, threadName);
    }

    private List<SqlQuery> getQueriesStartingWith(String theStart, String theThreadName) {
        return this.getCapturedQueries().stream().filter(t -> theThreadName == null || t.getThreadName().equals(theThreadName)).filter(t -> t.getSql(false, false).toLowerCase().startsWith(theStart)).collect(Collectors.toList());
    }

    private List<SqlQuery> getQueriesStartingWith(String theStart) {
        return this.getQueriesStartingWith(theStart, null);
    }

    private List<SqlQuery> getQueriesMatching(Predicate<String> thePredicate, String theThreadName) {
        return this.getCapturedQueries().stream().filter(t -> theThreadName == null || t.getThreadName().equals(theThreadName)).filter(t -> thePredicate.test(t.getSql(false, false))).collect(Collectors.toList());
    }

    private List<SqlQuery> getQueriesMatching(Predicate<String> thePredicate) {
        return this.getQueriesMatching(thePredicate, null);
    }

    private List<SqlQuery> getQueriesForCurrentThreadMatching(Predicate<String> thePredicate) {
        String threadName = Thread.currentThread().getName();
        return this.getQueriesMatching(thePredicate, threadName);
    }

    public int getCommitCount() {
        return this.myCommitCounter.get();
    }

    public int getRollbackCount() {
        return this.myRollbackCounter.get();
    }

    public List<SqlQuery> getSelectQueries() {
        return this.getQueriesMatching(this.mySelectQueryInclusionCriteria);
    }

    public List<SqlQuery> getInsertQueries() {
        return this.getQueriesStartingWith("insert");
    }

    public List<SqlQuery> getUpdateQueries() {
        return this.getQueriesStartingWith("update");
    }

    public List<SqlQuery> getDeleteQueries() {
        return this.getQueriesStartingWith("delete");
    }

    public List<SqlQuery> getSelectQueriesForCurrentThread() {
        return this.getQueriesForCurrentThreadMatching(this.mySelectQueryInclusionCriteria);
    }

    public List<SqlQuery> getInsertQueriesForCurrentThread() {
        return this.getQueriesForCurrentThreadStartingWith("insert");
    }

    public List<SqlQuery> getAllQueriesForCurrentThread() {
        return this.getQueriesForCurrentThreadStartingWith("");
    }

    public List<SqlQuery> getUpdateQueriesForCurrentThread() {
        return this.getQueriesForCurrentThreadStartingWith("update");
    }

    public List<SqlQuery> getDeleteQueriesForCurrentThread() {
        return this.getQueriesForCurrentThreadStartingWith("delete");
    }

    public String logUpdateQueriesForCurrentThread() {
        List<SqlQuery> queries = this.getUpdateQueriesForCurrentThread();
        List<String> queriesStrings = CircularQueueCaptureQueriesListener.renderQueriesForLogging(true, true, queries);
        String joined = String.join((CharSequence)"\n", queriesStrings);
        ourLog.info("Update Queries:\n{}", (Object)joined);
        return joined;
    }

    public String logSelectQueriesForCurrentThread(int ... theIndexes) {
        List<SqlQuery> queries = this.getSelectQueriesForCurrentThread();
        List<String> queriesStrings = CircularQueueCaptureQueriesListener.renderQueriesForLogging(true, true, queries);
        ArrayList<String> newList = new ArrayList<String>();
        if (theIndexes != null && theIndexes.length > 0) {
            for (int index : theIndexes) {
                newList.add(queriesStrings.get(index));
            }
            queriesStrings = newList;
        }
        String joined = String.join((CharSequence)"\n", queriesStrings);
        ourLog.info("Select Queries:\n{}", (Object)joined);
        return joined;
    }

    public List<SqlQuery> logSelectQueries() {
        return this.logSelectQueries(true, true);
    }

    public List<SqlQuery> logSelectQueries(boolean theInlineParams, boolean theFormatSql) {
        List<SqlQuery> queries = this.getSelectQueries();
        List<String> queriesStrings = CircularQueueCaptureQueriesListener.renderQueriesForLogging(theInlineParams, theFormatSql, queries);
        ourLog.info("Select Queries:\n{}", (Object)String.join((CharSequence)"\n", queriesStrings));
        return queries;
    }

    @Nonnull
    private static List<String> renderQueriesForLogging(boolean theInlineParams, boolean theFormatSql, List<SqlQuery> queries) {
        ArrayList<String> queriesStrings = new ArrayList<String>();
        for (int i = 0; i < queries.size(); ++i) {
            SqlQuery query = queries.get(i);
            String remderedString = "[" + i + "] " + CircularQueueCaptureQueriesListener.formatQueryAsSql(query, theInlineParams, theFormatSql);
            queriesStrings.add(remderedString);
        }
        return queriesStrings;
    }

    public void logFirstSelectQueryForCurrentThread() {
        boolean inlineParams = true;
        String firstSelectQuery = this.getSelectQueriesForCurrentThread().stream().findFirst().map(t -> CircularQueueCaptureQueriesListener.formatQueryAsSql(t, inlineParams, inlineParams)).orElse("NONE FOUND");
        ourLog.info("First select SqlQuery:\n{}", (Object)firstSelectQuery);
    }

    public String logInsertQueriesForCurrentThread() {
        List<SqlQuery> queries = this.getInsertQueriesForCurrentThread();
        List<String> queriesStrings = CircularQueueCaptureQueriesListener.renderQueriesForLogging(true, true, queries);
        String queriesAsString = String.join((CharSequence)"\n", queriesStrings);
        ourLog.info("Insert Queries:\n{}", (Object)queriesAsString);
        return queriesAsString;
    }

    public void logAllQueriesForCurrentThread() {
        List<SqlQuery> queries = this.getAllQueriesForCurrentThread();
        List<String> queriesStrings = CircularQueueCaptureQueriesListener.renderQueriesForLogging(true, true, queries);
        ourLog.info("Queries:\n{}", (Object)String.join((CharSequence)"\n", queriesStrings));
    }

    public void logAllQueries() {
        List<SqlQuery> queries = this.getCapturedQueries();
        List<String> queriesStrings = CircularQueueCaptureQueriesListener.renderQueriesForLogging(true, true, queries);
        ourLog.info("Queries:\n{}", (Object)String.join((CharSequence)"\n", queriesStrings));
    }

    public int logInsertQueries() {
        return this.logInsertQueries(null);
    }

    public int logInsertQueries(Predicate<SqlQuery> theInclusionPredicate) {
        List<SqlQuery> insertQueries = this.getInsertQueries().stream().filter(t -> theInclusionPredicate == null || theInclusionPredicate.test((SqlQuery)t)).collect(Collectors.toList());
        boolean inlineParams = true;
        List queries = insertQueries.stream().map(t -> CircularQueueCaptureQueriesListener.formatQueryAsSql(t, inlineParams, inlineParams)).collect(Collectors.toList());
        ourLog.info("Insert Queries:\n{}", (Object)String.join((CharSequence)"\n", queries));
        return CircularQueueCaptureQueriesListener.countQueries(insertQueries);
    }

    public int logUpdateQueries() {
        List<SqlQuery> queries = this.getUpdateQueries();
        List<String> queriesStrings = CircularQueueCaptureQueriesListener.renderQueriesForLogging(true, true, queries);
        ourLog.info("Update Queries:\n{}", (Object)String.join((CharSequence)"\n", queriesStrings));
        return CircularQueueCaptureQueriesListener.countQueries(queries);
    }

    public String logDeleteQueriesForCurrentThread() {
        List<SqlQuery> queries = this.getDeleteQueriesForCurrentThread();
        List<String> queriesStrings = CircularQueueCaptureQueriesListener.renderQueriesForLogging(true, true, queries);
        String joined = String.join((CharSequence)"\n", queriesStrings);
        ourLog.info("Delete Queries:\n{}", (Object)joined);
        return joined;
    }

    public int logDeleteQueries() {
        List<SqlQuery> queries = this.getDeleteQueries();
        List<String> queriesStrings = CircularQueueCaptureQueriesListener.renderQueriesForLogging(true, true, queries);
        ourLog.info("Delete Queries:\n{}", (Object)String.join((CharSequence)"\n", queriesStrings));
        return CircularQueueCaptureQueriesListener.countQueries(queries);
    }

    public int countSelectQueries() {
        return CircularQueueCaptureQueriesListener.countQueries(this.getSelectQueries());
    }

    public int countInsertQueries() {
        return CircularQueueCaptureQueriesListener.countQueries(this.getInsertQueries());
    }

    public int countUpdateQueries() {
        return CircularQueueCaptureQueriesListener.countQueries(this.getUpdateQueries());
    }

    public int countDeleteQueries() {
        return CircularQueueCaptureQueriesListener.countQueries(this.getDeleteQueries());
    }

    public int countSelectQueriesForCurrentThread() {
        return CircularQueueCaptureQueriesListener.countQueries(this.getSelectQueriesForCurrentThread());
    }

    public int countInsertQueriesForCurrentThread() {
        return CircularQueueCaptureQueriesListener.countQueries(this.getInsertQueriesForCurrentThread());
    }

    public int countUpdateQueriesForCurrentThread() {
        return CircularQueueCaptureQueriesListener.countQueries(this.getUpdateQueriesForCurrentThread());
    }

    public int countDeleteQueriesForCurrentThread() {
        return CircularQueueCaptureQueriesListener.countQueries(this.getDeleteQueriesForCurrentThread());
    }

    @Nonnull
    private static Integer countQueries(List<SqlQuery> theQueries) {
        return theQueries.stream().map(t -> t.getSize()).reduce(0, Integer::sum);
    }

    @Nonnull
    static String formatQueryAsSql(SqlQuery theQuery) {
        boolean inlineParams = true;
        boolean formatSql = true;
        return CircularQueueCaptureQueriesListener.formatQueryAsSql(theQuery, inlineParams, formatSql);
    }

    @Nonnull
    static String formatQueryAsSql(SqlQuery theQuery, boolean inlineParams, boolean formatSql) {
        String formattedSql = theQuery.getSql(inlineParams, formatSql);
        StringBuilder b = new StringBuilder();
        b.append("SqlQuery at ");
        b.append(new InstantType(new Date(theQuery.getQueryTimestamp())).getValueAsString());
        if (theQuery.getRequestPartitionId() != null && theQuery.getRequestPartitionId().hasPartitionIds()) {
            b.append(" on partition ");
            b.append(theQuery.getRequestPartitionId().getPartitionIds());
        }
        b.append(" took ").append(StopWatch.formatMillis((long)theQuery.getElapsedTime()));
        b.append(" on Thread: ").append(theQuery.getThreadName());
        if (theQuery.getSize() > 1) {
            b.append("\nExecution Count: ").append(theQuery.getSize()).append(" (parameters shown are for first execution)");
        }
        b.append("\nSQL:\n").append(formattedSql);
        if (theQuery.getStackTrace() != null) {
            b.append("\nStack:\n   ");
            Stream<String> stackTraceStream = Arrays.stream(theQuery.getStackTrace()).map(StackTraceElement::toString).filter(t -> t.startsWith("ca."));
            b.append(stackTraceStream.collect(Collectors.joining("\n   ")));
        }
        b.append("\n");
        return b.toString();
    }
}

