/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.validation.ValidationSettings;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.utils.validation.IMessagingServices;
import org.hl7.fhir.r5.utils.validation.IResourceValidator;
import org.hl7.fhir.r5.utils.validation.IValidationPolicyAdvisor;
import org.hl7.fhir.r5.utils.validation.constants.BindingKind;
import org.hl7.fhir.r5.utils.validation.constants.ContainedReferenceValidationPolicy;
import org.hl7.fhir.r5.utils.validation.constants.ReferenceValidationPolicy;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ValidatorPolicyAdvisor
implements IValidationPolicyAdvisor {
    private static final Logger ourLog = LoggerFactory.getLogger(ValidatorPolicyAdvisor.class);
    @Autowired
    private ValidationSettings myValidationSettings;
    @Autowired
    private FhirContext myFhirContext;

    public ReferenceValidationPolicy policyForReference(IResourceValidator validator, Object appContext, String path, String url) {
        int slashIdx = url.indexOf("/");
        if (slashIdx > 0 && this.myFhirContext.getResourceTypes().contains(url.substring(0, slashIdx))) {
            return this.myValidationSettings.getLocalReferenceValidationDefaultPolicy();
        }
        return ReferenceValidationPolicy.IGNORE;
    }

    public EnumSet<IValidationPolicyAdvisor.ResourceValidationAction> policyForResource(IResourceValidator validator, Object appContext, StructureDefinition type, String path) {
        return EnumSet.allOf(IValidationPolicyAdvisor.ResourceValidationAction.class);
    }

    public EnumSet<IValidationPolicyAdvisor.ElementValidationAction> policyForElement(IResourceValidator validator, Object appContext, StructureDefinition structure, ElementDefinition element, String path) {
        return EnumSet.allOf(IValidationPolicyAdvisor.ElementValidationAction.class);
    }

    public EnumSet<IValidationPolicyAdvisor.CodedContentValidationAction> policyForCodedContent(IResourceValidator validator, Object appContext, String stackPath, ElementDefinition definition, StructureDefinition structure, BindingKind kind, IValidationPolicyAdvisor.AdditionalBindingPurpose purpose, ValueSet valueSet, List<String> systems) {
        return EnumSet.allOf(IValidationPolicyAdvisor.CodedContentValidationAction.class);
    }

    public ContainedReferenceValidationPolicy policyForContained(IResourceValidator validator, Object appContext, StructureDefinition structure, ElementDefinition element, String containerType, String containerId, Element.SpecialElement containingResourceType, String path, String url) {
        return ContainedReferenceValidationPolicy.CHECK_VALID;
    }

    public List<StructureDefinition> getImpliedProfilesForResource(IResourceValidator validator, Object appContext, String stackPath, ElementDefinition definition, StructureDefinition structure, Element resource, boolean valid, IMessagingServices msgServices, List<ValidationMessage> messages) {
        return Arrays.asList(new StructureDefinition[0]);
    }

    public boolean isSuppressMessageId(String path, String messageId) {
        return false;
    }

    public ReferenceValidationPolicy getReferencePolicy() {
        return ReferenceValidationPolicy.IGNORE;
    }
}

